package com.elitesland.tw.tw5.server.prd.cal.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalTaskSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.entity.QCalTaskSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalTaskSettleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Repository
@RequiredArgsConstructor
public class CalTaskSettleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CalTaskSettleRepo repo;
    private final QCalTaskSettleDO qdo = QCalTaskSettleDO.calTaskSettleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CalTaskSettleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CalTaskSettleVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 结算单号
                qdo.settleNo,
                // 结算状态
                qdo.settleStatus,
                // 审批状态
                qdo.apprStatus,
                // 流程实例id
                qdo.procInstId,
                // 结算类型（任务包总价结算，任务包单价结算）
                qdo.settleType,
                // 结算日期
                qdo.settleDate,
                // 财务期间id
                qdo.finPeriodId,
                // 验收方式
                qdo.acceptMethod,
                // 项目id
                qdo.projId,
                qdo.projName,
                // 任务包id
                qdo.taskId,
                qdo.taskName,
                // 支出bu_id
                qdo.expenseBuId,
                // 收入资源id
                qdo.incomeResId,
                //发包人id
                qdo.disterResId,
                // 收入bu_id
                qdo.resBuId,
                // 当量系数
                qdo.eqvaRatio,
                // 当量工资(收入单价)
                qdo.eqvaSalary,
                // 申请结算当量数
                qdo.applySettleEqva,
                // 申请结算总额
                qdo.applySettleAmt,
                // 申请结算总额
                qdo.applySettleAmt,
                //申请收入总额
                qdo.applyIncomeAmt,
                // 结算单价
                qdo.settlePrice,
                // 实际结算当量数
                qdo.approveSettleEqva,
                // 实际结算总额
                qdo.approveSettleAmt,
                // 实际收入总额
                qdo.approveIncomeAmt,
                // 币种
                qdo.currCode,
                // 质保金比例
                qdo.guaranteeRate,
                // 质保当量
                qdo.graranteeEqva,
                // 质保总额（冻结金额）
                qdo.graranteeAmt,
                // 申请人资源id
                qdo.applyResId,
                // 评价状态
                qdo.evalStatus,
                // 累计提现当量
                qdo.withdrawEqva,
                // bu累计提现当量
                qdo.buWithdrawEqva,
                //f附件
                qdo.fileCodes,
                //事由类型
                qdo.reasonType,
                //可提现当量
                qdo.avalQty,
                //操作标识
                qdo.operateFlag
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CalTaskSettleVO> getJpaQueryWhere(CalTaskSettleQuery query) {
        JPAQuery<CalTaskSettleVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(CalTaskSettleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(CalTaskSettleQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 结算单号 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleNo())) {
            list.add(qdo.settleNo.eq(query.getSettleNo()));
        }
        /** 结算状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStatus())) {
            list.add(qdo.settleStatus.eq(query.getSettleStatus()));
        }
        /** 结算状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStatusList())) {
            list.add(qdo.settleStatus.in(query.getSettleStatusList()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        /** 流程实例id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 结算类型（任务包总价结算，任务包单价结算） 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleType())) {
            list.add(qdo.settleType.eq(query.getSettleType()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleDate())) {
            list.add(qdo.settleDate.eq(query.getSettleDate()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStartDate())) {
            list.add(qdo.settleDate.goe(query.getSettleStartDate()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleEndDate())) {
            list.add(qdo.settleDate.loe(query.getSettleEndDate()));
        }
        /** 财务期间id 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            list.add(qdo.finPeriodId.eq(query.getFinPeriodId()));
        }
        /** 验收方式 精确 */
        if (!ObjectUtils.isEmpty(query.getAcceptMethod())) {
            list.add(qdo.acceptMethod.eq(query.getAcceptMethod()));
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 任务包id 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskId())) {
            list.add(qdo.taskId.eq(query.getTaskId()));
        }
        /** 支出bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** 收入资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getIncomeResId())) {
            list.add(qdo.incomeResId.eq(query.getIncomeResId()));
        }
        /** 收入bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getResBuId())) {
            list.add(qdo.resBuId.eq(query.getResBuId()));
        }
        /** 当量系数 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaRatio())) {
            list.add(qdo.eqvaRatio.eq(query.getEqvaRatio()));
        }
        /** 当量工资(收入单价) 精确 */
        if (!ObjectUtils.isEmpty(query.getEqvaSalary())) {
            list.add(qdo.eqvaSalary.eq(query.getEqvaSalary()));
        }
        /** 申请结算当量数 精确 */
        if (!ObjectUtils.isEmpty(query.getApplySettleEqva())) {
            list.add(qdo.applySettleEqva.eq(query.getApplySettleEqva()));
        }
        /** 申请结算总额 精确 */
        if (!ObjectUtils.isEmpty(query.getApplySettleAmt())) {
            list.add(qdo.applySettleAmt.eq(query.getApplySettleAmt()));
        }
        /** 结算单价 精确 */
        if (!ObjectUtils.isEmpty(query.getSettlePrice())) {
            list.add(qdo.settlePrice.eq(query.getSettlePrice()));
        }
        /** 实际结算当量数 精确 */
        if (!ObjectUtils.isEmpty(query.getApproveSettleEqva())) {
            list.add(qdo.approveSettleEqva.eq(query.getApproveSettleEqva()));
        }
        /** 实际结算总额 精确 */
        if (!ObjectUtils.isEmpty(query.getApproveSettleAmt())) {
            list.add(qdo.approveSettleAmt.eq(query.getApproveSettleAmt()));
        }
        /** 币种 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            list.add(qdo.currCode.eq(query.getCurrCode()));
        }
        /** 质保金比例 精确 */
        if (!ObjectUtils.isEmpty(query.getGuaranteeRate())) {
            list.add(qdo.guaranteeRate.eq(query.getGuaranteeRate()));
        }
        /** 质保当量 精确 */
        if (!ObjectUtils.isEmpty(query.getGraranteeEqva())) {
            list.add(qdo.graranteeEqva.eq(query.getGraranteeEqva()));
        }
        /** 申请人资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 评价状态 精确 */
        if (!ObjectUtils.isEmpty(query.getEvalStatus())) {
            list.add(qdo.evalStatus.eq(query.getEvalStatus()));
        }
        /** 累计提现当量 精确 */
        if (!ObjectUtils.isEmpty(query.getWithdrawEqva())) {
            list.add(qdo.withdrawEqva.eq(query.getWithdrawEqva()));
        }
        /** bu累计提现当量 精确 */
        if (!ObjectUtils.isEmpty(query.getBuWithdrawEqva())) {
            list.add(qdo.buWithdrawEqva.eq(query.getBuWithdrawEqva()));
        }
        if (query.getSearchType() != null && query.getSearchType() == 1) {
            //可提现当量大于某个值
            list.add(qdo.avalQty.gt(BigDecimal.ZERO));
            //操作状态
            list.add(qdo.operateFlag.eq(0).or(qdo.operateFlag.isNull()));
        }

        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CalTaskSettleVO queryByKey(Long id) {
        JPAQuery<CalTaskSettleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CalTaskSettleVO> queryListDynamic(CalTaskSettleQuery query) {
        JPAQuery<CalTaskSettleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CalTaskSettleVO> queryPaging(CalTaskSettleQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<CalTaskSettleVO> jpaQuery = getJpaQueryWhere(query);
        List<CalTaskSettleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<CalTaskSettleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CalTaskSettleDO save(CalTaskSettleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CalTaskSettleDO> saveAll(List<CalTaskSettleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CalTaskSettlePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 结算单号
        if (payload.getSettleNo() != null) {
            update.set(qdo.settleNo, payload.getSettleNo());
        }
        // 结算状态
        if (payload.getSettleStatus() != null) {
            update.set(qdo.settleStatus, payload.getSettleStatus());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 结算类型（任务包总价结算，任务包单价结算）
        if (payload.getSettleType() != null) {
            update.set(qdo.settleType, payload.getSettleType());
        }
        // 结算日期
        if (payload.getSettleDate() != null) {
            update.set(qdo.settleDate, payload.getSettleDate());
        }
        // 财务期间id
        if (payload.getFinPeriodId() != null) {
            update.set(qdo.finPeriodId, payload.getFinPeriodId());
        }
        // 验收方式
        if (payload.getAcceptMethod() != null) {
            update.set(qdo.acceptMethod, payload.getAcceptMethod());
        }
        // 项目id
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 任务包id
        if (payload.getTaskId() != null) {
            update.set(qdo.taskId, payload.getTaskId());
        }
        // 支出bu_id
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 收入资源id
        if (payload.getIncomeResId() != null) {
            update.set(qdo.incomeResId, payload.getIncomeResId());
        }
        // 收入bu_id
        if (payload.getResBuId() != null) {
            update.set(qdo.resBuId, payload.getResBuId());
        }
        // 当量系数
        if (payload.getEqvaRatio() != null) {
            update.set(qdo.eqvaRatio, payload.getEqvaRatio());
        }
        // 当量工资(收入单价)
        if (payload.getEqvaSalary() != null) {
            update.set(qdo.eqvaSalary, payload.getEqvaSalary());
        }
        // 申请结算当量数
        if (payload.getApplySettleEqva() != null) {
            update.set(qdo.applySettleEqva, payload.getApplySettleEqva());
        }
        // 申请结算总额
        if (payload.getApplySettleAmt() != null) {
            update.set(qdo.applySettleAmt, payload.getApplySettleAmt());
        }
        // 申请收入总额
        if (payload.getApplyIncomeAmt() != null) {
            update.set(qdo.applyIncomeAmt, payload.getApplyIncomeAmt());
        }
        // 结算单价
        if (payload.getSettlePrice() != null) {
            update.set(qdo.settlePrice, payload.getSettlePrice());
        }
        // 实际结算当量数
        if (payload.getApproveSettleEqva() != null) {
            update.set(qdo.approveSettleEqva, payload.getApproveSettleEqva());
        }
        // 实际结算总额
        if (payload.getApproveSettleAmt() != null) {
            update.set(qdo.approveSettleAmt, payload.getApproveSettleAmt());
        }
        // 实际收入总额
        if (payload.getApproveIncomeAmt() != null) {
            update.set(qdo.approveIncomeAmt, payload.getApproveIncomeAmt());
        }
        // 币种
        if (payload.getCurrCode() != null) {
            update.set(qdo.currCode, payload.getCurrCode());
        }
        // 质保金比例
        if (payload.getGuaranteeRate() != null) {
            update.set(qdo.guaranteeRate, payload.getGuaranteeRate());
        }
        // 质保当量
        if (payload.getGraranteeEqva() != null) {
            update.set(qdo.graranteeEqva, payload.getGraranteeEqva());
        }
        // 质保总额（冻结金额）
        if (payload.getGraranteeAmt() != null) {
            update.set(qdo.graranteeAmt, payload.getGraranteeAmt());
        }
        // 申请人资源id
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 评价状态
        if (payload.getEvalStatus() != null) {
            update.set(qdo.evalStatus, payload.getEvalStatus());
        }
        // 累计提现当量
        if (payload.getWithdrawEqva() != null) {
            update.set(qdo.withdrawEqva, payload.getWithdrawEqva());
        }
        // bu累计提现当量
        if (payload.getBuWithdrawEqva() != null) {
            update.set(qdo.buWithdrawEqva, payload.getBuWithdrawEqva());
        }
        // 评价状态
        if (payload.getEvalStatus() != null) {
            update.set(qdo.evalStatus, payload.getEvalStatus());
        }
        // 可用当量
        if (payload.getAvalQty() != null) {
            update.set(qdo.avalQty, payload.getAvalQty());
        }
        // 操作标识
        if (payload.getOperateFlag() != null) {
            update.set(qdo.operateFlag, payload.getOperateFlag());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 结算单号
            if (nullFields.contains("settleNo")) {
                update.setNull(qdo.settleNo);
            }
            // 结算状态
            if (nullFields.contains("settleStatus")) {
                update.setNull(qdo.settleStatus);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 结算类型（任务包总价结算，任务包单价结算）
            if (nullFields.contains("settleType")) {
                update.setNull(qdo.settleType);
            }
            // 结算日期
            if (nullFields.contains("settleDate")) {
                update.setNull(qdo.settleDate);
            }
            // 财务期间id
            if (nullFields.contains("finPeriodId")) {
                update.setNull(qdo.finPeriodId);
            }
            // 验收方式
            if (nullFields.contains("acceptMethod")) {
                update.setNull(qdo.acceptMethod);
            }
            // 项目id
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 任务包id
            if (nullFields.contains("taskId")) {
                update.setNull(qdo.taskId);
            }
            // 支出bu_id
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // 收入资源id
            if (nullFields.contains("incomeResId")) {
                update.setNull(qdo.incomeResId);
            }
            // 收入bu_id
            if (nullFields.contains("resBuId")) {
                update.setNull(qdo.resBuId);
            }
            // 当量系数
            if (nullFields.contains("eqvaRatio")) {
                update.setNull(qdo.eqvaRatio);
            }
            // 当量工资(收入单价)
            if (nullFields.contains("eqvaSalary")) {
                update.setNull(qdo.eqvaSalary);
            }
            // 申请结算当量数
            if (nullFields.contains("applySettleEqva")) {
                update.setNull(qdo.applySettleEqva);
            }
            // 申请结算总额
            if (nullFields.contains("applySettleAmt")) {
                update.setNull(qdo.applySettleAmt);
            }
            // 结算单价
            if (nullFields.contains("settlePrice")) {
                update.setNull(qdo.settlePrice);
            }
            // 实际结算当量数
            if (nullFields.contains("approveSettleEqva")) {
                update.setNull(qdo.approveSettleEqva);
            }
            // 实际结算总额
            if (nullFields.contains("approveSettleAmt")) {
                update.setNull(qdo.approveSettleAmt);
            }
            // 币种
            if (nullFields.contains("currCode")) {
                update.setNull(qdo.currCode);
            }
            // 质保金比例
            if (nullFields.contains("guaranteeRate")) {
                update.setNull(qdo.guaranteeRate);
            }
            // 质保当量
            if (nullFields.contains("graranteeEqva")) {
                update.setNull(qdo.graranteeEqva);
            }
            // 申请人资源id
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 评价状态
            if (nullFields.contains("evalStatus")) {
                update.setNull(qdo.evalStatus);
            }
            // 累计提现当量
            if (nullFields.contains("withdrawEqva")) {
                update.setNull(qdo.withdrawEqva);
            }
            // bu累计提现当量
            if (nullFields.contains("buWithdrawEqva")) {
                update.setNull(qdo.buWithdrawEqva);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<CalTaskSettleVO> queryByKeys(List<Long> ids) {
        JPAQuery<CalTaskSettleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 期间变更
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long updateSettleDate(List<Long> keys, LocalDate settleDate) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.settleDate, settleDate)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 提现或解冻标识
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long updateSettleOperate(List<Long> keys, Integer operateFlag) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.operateFlag, operateFlag)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

