package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

public enum RestStatusEnum {
    CREATE("CREATE", "未调休"),
    REST_APPROVING("REST_APPROVING", "调休审批中"),
    RESTED("RESTED", "已调休"),
    REJECTED("REJECTED", "已退回"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    RestStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RestStatusEnum getByCode(String code) {
        for (RestStatusEnum value : RestStatusEnum.values()) {
            if (value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
