package com.elitesland.tw.tw5.server.prd.copartner.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Entity
@Table(name = "performance_readme_config_user", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "performance_readme_config_user", comment = "合伙人绩效自述员工表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PerformanceReadmeConfigUserDO extends BaseModel implements Serializable {
    /**
     * 配置主键
     */
    @Comment("配置主键")
    @Column()
    private Long configId;
    /**
     * 员工主键
     */
    @Comment("员工主键")
    @Column()
    private Long userId;

    @Comment("buId")
    @Column()
    private Long buId;
    /**
     * 状态：0未开始或流程中，1已完成
     */
    @Comment("状态：0未开始或流程中，1已完成")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer applyStatus;
    /**
     * 名称
     */
    @Comment("名称")
    @Column()
    private String configUserName;
    /**
     * 审批名称
     */
    @Comment("审批名称")
    @Column()
    private String procInstName;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String procInstStatus;
    /**
     * 流程id
     */
    @Comment("流程id")
    @Column()
    private String procInstId;

    public void copy(PerformanceReadmeConfigUserDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
