package com.elitesland.tw.tw5.server.prd.copartner.workflow;

import cn.hutool.json.JSONUtil;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigService;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CopartnerEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * 合伙人相关流程回调
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "COPARTNER_{procDefKey}" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class CopartnerWorkflowCallBackController implements WorkflowCallBack {
    private final PerformanceReadmeConfigService performanceReadmeConfigService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {

        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);

        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
//        try {
        log.info("任务流程状态变化回调参数: {}", JSONUtil.toJsonStr(payload));
        if (payload.getProcDefKey().equals(CopartnerEnum.ProcDefKey.COPARTNER_REPORT.getCode())) {
            log.info("调用合伙人绩效service");
            //调用项目汇报的service
            performanceReadmeConfigService.processStatusChange(payload);
        }

        return WorkflowResult.success(null);
//        } catch (TwException ex) {
//            WorkflowResult result = new WorkflowResult(false, ex.getErrors().toString(), null);
//            return result;
//        }
    }
}
