
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreRulePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreRuleQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreRuleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreRuleDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOffshoreRuleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOffshoreRuleRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmOffshoreRuleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOffshoreRuleRepo repo;
    private final QCrmOffshoreRuleDO qdo = QCrmOffshoreRuleDO.crmOffshoreRuleDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOffshoreRuleDO save(CrmOffshoreRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmOffshoreRuleDO> saveAll(List<CrmOffshoreRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结果
     */
    public CrmOffshoreRuleVO queryByKey(Long id){
        JPAQuery<CrmOffshoreRuleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }




    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<CrmOffshoreRuleVO> getJpaQuerySelect() {
        JPAQuery<CrmOffshoreRuleVO> jpaQuery=jpaQueryFactory.select(Projections.bean(CrmOffshoreRuleVO.class,
                qdo.id,
                qdo.distributeReceiveRule,
                qdo.newLeadsRemind,
                qdo.receiveLeadsLimit,
                qdo.receiveLeadsLimitDays,
                qdo.receiveLeadsRemind,
                qdo.distributeLeadsRemindTime,
                qdo.followLeadsRemindTime,
                qdo.showFollowBeforeReceive
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOffshoreRuleVO> getJpaQueryWhere(CrmOffshoreRuleQuery query) {
        JPAQuery<CrmOffshoreRuleVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getDistributeReceiveRule())) {
            jpaQuery.where(qdo.distributeReceiveRule.eq(query.getDistributeReceiveRule()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveLeadsRemind())) {
            jpaQuery.where(qdo.receiveLeadsRemind.eq(query.getReceiveLeadsRemind()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveLeadsLimit())) {
            jpaQuery.where(qdo.receiveLeadsLimit.eq(query.getReceiveLeadsLimit()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveLeadsLimitDays())) {
            jpaQuery.where(qdo.receiveLeadsLimitDays.eq(query.getReceiveLeadsLimitDays()));
        }
        if (!ObjectUtils.isEmpty(query.getReceiveLeadsRemind())) {
            jpaQuery.where(qdo.receiveLeadsRemind.eq(query.getReceiveLeadsRemind()));
        }
        if (!ObjectUtils.isEmpty(query.getDistributeLeadsRemindTime())) {
            jpaQuery.where(qdo.distributeLeadsRemindTime.eq(query.getDistributeLeadsRemindTime()));
        }
        if (!ObjectUtils.isEmpty(query.getFollowLeadsRemindTime())) {
            jpaQuery.where(qdo.followLeadsRemindTime.eq(query.getFollowLeadsRemindTime()));
        }
        if (!ObjectUtils.isEmpty(query.getShowFollowBeforeReceive())) {
            jpaQuery.where(qdo.showFollowBeforeReceive.eq(query.getShowFollowBeforeReceive()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合(不分页查询)
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmOffshoreRuleVO> queryListDynamic(CrmOffshoreRuleQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmOffshoreRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }



    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOffshoreRuleVO> queryPaging(CrmOffshoreRuleQuery query){
        JPAQuery<CrmOffshoreRuleVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmOffshoreRuleVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmOffshoreRuleVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(CrmOffshoreRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getDistributeReceiveRule() != null) {
            update.set(qdo.distributeReceiveRule, payload.getDistributeReceiveRule());
        }
        if (payload.getNewLeadsRemind() != null) {
            update.set(qdo.newLeadsRemind, payload.getNewLeadsRemind());
        }
        if (payload.getReceiveLeadsLimit() != null) {
            update.set(qdo.receiveLeadsLimit, payload.getReceiveLeadsLimit());
        }
        if (payload.getReceiveLeadsLimitDays() != null) {
            update.set(qdo.receiveLeadsLimitDays, payload.getReceiveLeadsLimitDays());
        }
        if (payload.getReceiveLeadsRemind() != null) {
            update.set(qdo.receiveLeadsRemind, payload.getReceiveLeadsRemind());
        }
        if (payload.getFollowLeadsRemindTime() != null) {
            update.set(qdo.followLeadsRemindTime, payload.getFollowLeadsRemindTime());
        }
        if (payload.getShowFollowBeforeReceive() != null) {
            update.set(qdo.showFollowBeforeReceive, payload.getShowFollowBeforeReceive());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }
}
