package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Entity
@Table(name = "crm_leads", indexes = {
        @Index(name = "formal_customer_index", columnList = "formal_customer_id"),

})
@org.hibernate.annotations.Table(appliesTo = "crm_leads", comment = "线索表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
@NamedEntityGraphs({
        @NamedEntityGraph(name = "offshore.leads.list", attributeNodes = {
                @NamedAttributeNode(value = "leadsOffshores", subgraph = "offshore"),
                @NamedAttributeNode(value = "market"),
//                @NamedAttributeNode(value = "saleUser"),
                @NamedAttributeNode(value = "customer"),

        },
                subgraphs = {
                        @NamedSubgraph(name = "offshore", attributeNodes = {
                                @NamedAttributeNode("offshore"),
                        })
                }),
        @NamedEntityGraph(name = "offshore.leads.detail", attributeNodes = {
                @NamedAttributeNode(value = "leadsOffshores", subgraph = "offshore"),
                @NamedAttributeNode(value = "market"),
//                @NamedAttributeNode(value = "saleUser"),
                @NamedAttributeNode(value = "customer"),
//                @NamedAttributeNode(value = "leadsLogs", subgraph = "logDetail"),
//                @NamedAttributeNode(value = "leadsFollows"),
//                @NamedAttributeNode(value = "leadsMembers"),
//                @NamedAttributeNode(value = "bonusDistributeTo"),
//                @NamedAttributeNode(value = "sourceUser")
        },
                subgraphs = {
//                @NamedSubgraph(name = "logDetail", attributeNodes = {
//                        @NamedAttributeNode("details"),
//                }),
                        @NamedSubgraph(name = "offshore", attributeNodes = {
                                @NamedAttributeNode("offshore"),
                        })
                })
})
public class CrmLeadsDO extends BaseModel implements Cloneable {

    //    @FieldUpdateLog(objectNameField = "leadsName",selectionKey = "OFFSHORE",changeAction = "转移到")
//    @FieldCreateLog(fieldName = "近海",selectionKey = "OFFSHORE")
    @Comment("近海")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "leadsId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmLeadsOffshoreDO> leadsOffshores;

    @FieldUpdateLog(fieldName = "标签", selectionKey = "crm:tags")
    @FieldCreateLog(fieldName = "标签", selectionKey = "crm:tags")
    @Comment("线索标签列表")
    private String leadsTagIds;

    @FieldUpdateLog(fieldName = "线索编号")
    @FieldCreateLog(fieldName = "线索编号")
    @Comment("线索编号")
    @Column(name = "leads_no", nullable = false)
    private String leadsNo;

    @FieldUpdateLog(fieldName = "线索名称")
    @FieldCreateLog(fieldName = "线索名称")
    @Comment("线索名称")
    @Column(name = "leads_name", nullable = false)
    private String leadsName;

    @FieldUpdateLog(fieldName = "线索状态", selectionKey = "crm:leads_status")
    @FieldCreateLog(fieldName = "线索状态", selectionKey = "crm:leads_status")
    @Comment("线索状态")
    @Column(name = "leads_status", nullable = false)
    private String leadsStatus;

    @FieldCreateLog(fieldName = "线索阶段", selectionKey = "crm:leads_stage")
    @FieldUpdateLog(objectNameField = "leadsName", selectionKey = "crm:leads_stage", changeAction = "标记为")
    @Comment("线索阶段")
    @Column(name = "leads_stage", nullable = false)
    private String leadsStage;

    @FieldUpdateLog(fieldName = "来源类型", selectionKey = "crm:leads_source_type")
    @FieldCreateLog(fieldName = "来源类型", selectionKey = "crm:leads_source_type")
    @Comment("来源类型")
    @Column(name = "source_type", nullable = false)
    private String sourceType;

    @Comment("市场活动")
    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    //@ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "marketId", referencedColumnName = "id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private PrjProjectDO market;


    @Comment("潜在客户")
    @Column(name = "potential_customer_id")
    private Long potentialCustomerId;

    @FieldUpdateLog(fieldName = "市场渠道", selectionKey = "crm:leads_channel")
    @FieldCreateLog(fieldName = "市场渠道", selectionKey = "crm:leads_channel")
    @Comment("市场渠道")
    @Column(name = "market_channel")
    private String marketChannel;

    @Comment("渠道")
    @Column(name = "channel")
    private String channel;

    @FieldUpdateLog(fieldName = "奖金分配类型", selectionKey = "crm:leads_source_type")
    @FieldCreateLog(fieldName = "奖金分配类型", selectionKey = "crm:leads_source_type")
    @Comment("奖金分配类型")
    @Column(name = "bonus_distribute_type")
    private String bonusDistributeType;

    //    @FieldUpdateLog(fieldName = "销售人员",selectionKey = "USER")
    @FieldUpdateLog(objectNameField = "leadsName", selectionKey = "USER", changeAction = "分配给")
    @FieldCreateLog(fieldName = "销售人员", selectionKey = "USER")
    @Comment("销售人员")
    @Column(name = "sale_user_id")
    private Long saleUserId;

    @Comment("上一任销售人员")
    @Column(name = "pre_sale_user_id")
    private Long preSaleUserId;

    @FieldUpdateLog(fieldName = "奖金分配对象", selectionKey = "USER")
    @FieldCreateLog(fieldName = "奖金分配对象", selectionKey = "USER")
    @Comment("奖金分配对象")
    @Column(name = "bonus_distribute_to")
    private Long bonusDistributeTo;

    @FieldUpdateLog(fieldName = "来源人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "来源人", selectionKey = "USER")
    @Comment("来源人")
    @Column(name = "source_user_id")
    private Long sourceUserId;

    @FieldUpdateLog(fieldName = "关闭原因")
    @Comment("关闭原因")
    @Column(name = "close_reason")
    private String closeReason;

    @FieldUpdateLog(fieldName = "需求产品", selectionKey = "crm:leads_demand_product")
    @FieldCreateLog(fieldName = "需求产品", selectionKey = "crm:leads_demand_product")
    @Comment("需求产品")
    @Column()
    private String demandProduct;

    @FieldUpdateLog(fieldName = "需求产品归属部门", selectionKey = "BU")
    @FieldCreateLog(fieldName = "需求产品归属部门", selectionKey = "BU")
    @Comment("需求产品归属部门")
    @Column()
    private Long demandProductOrg;

    @FieldUpdateLog(fieldName = "收回原因")
    @Comment("收回原因")
    @Column(name = "withdraw_reason")
    private String withdrawReason;

    @FieldUpdateLog(fieldName = "退回原因")
    @Comment("退回原因")
    @Column(name = "back_reason")
    private String backReason;

    @FieldUpdateLog(fieldName = "转移原因")
    @Comment("转移原因")
    @Column(name = "transfer_reason")
    private String transferReason;

    @FieldUpdateLog(fieldName = "分配日期")
    @Comment("分配日期")
    @Column(name = "distribute_date")
    private LocalDate distributeDate;


    @FieldUpdateLog(fieldObject = "customer")
    @FieldCreateLog(fieldObject = "customer")
    @Comment("客户")
    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "customerId", referencedColumnName = "id", unique = false)
    private CrmLeadsCustomerDO customer;

//    @Comment("线索操作日志表")
//    @OrderColumn
//    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
//    @JoinColumn(name="leadsId")
//    private List<PrdSystemLogDO> leadsLogs;
//
//    @Comment("跟进表")
//    @OrderColumn
//    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
//    @JoinColumn(name="leadsId")
//    private List<CrmFollowDO> leadsFollows;
//
//
//
//    @Comment("线索成员表")
//    @OrderColumn
//    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
//    @JoinColumn(name="leadsId")
//    private List<CrmLeadsMembersDO> leadsMembers;

    @Comment("关联正式客户id")
    @Column(name = "formal_customer_id")
    private Long formalCustomerId;

    @Transient
    private CrmOffshoreDO offshore;


    @Comment("近海")
    @Column(name = "offshore_id")
    private Long offshoreId;

    @Comment("未跟进提醒时间")
    private LocalDateTime notFollowLeadsRemindTime;

    @Comment("预留字段1")
    @Column()
    private String extString1;

    @Comment("预留字段2")
    @Column()
    private String extString2;

    @Comment("预留字段3")
    @Column()
    private String extString3;

    @Comment("预留字段4")
    @Column()
    private String extString4;

    @Comment("预留字段5")
    @Column()
    private String extString5;

    @Comment("4.0线索id")
    @Column()
    private Long leadsIdV4;//线索id

//    @FieldUpdateLog(fieldName = "业务伙伴ID")
//    @Comment("业务伙伴ID")
//    @Column(name = "partner_id")
//    private Long partnerId;

    /**
     * 是否时导出操作
     */
    @Transient
    private Boolean dumpFlag;


    @Override
    public Object clone() {
        CrmLeadsDO leads = null;
        try {
            leads = (CrmLeadsDO) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return leads;
    }

    @FieldUpdateLog(fieldName = "年营业额")
    @FieldCreateLog(fieldName = "年营业额")
    @Comment("年营业额")
    @Column()
    private String annualTurnover;

    @FieldUpdateLog(fieldName = "城市", selectionKey = "SYSTEM_BASIC:PCD")
    @FieldCreateLog(fieldName = "城市")
    @Comment("城市")
    @Column()
    private String area;



    public void copy(CrmPotentialCustomerDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
