package com.elitesland.tw.tw5.server.prd.crm.visit.controller;

import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerForVisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitTaskService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Api(tags = "销售拜访任务管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/visit/task")
@Slf4j
public class VisitTaskController {

    private final VisitTaskService visitTaskService;
    @Autowired
    private PrdOrgEmployeeService prdOrgEmployeeService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.insert(payload));
    }

    /**
     * 单独新增拜访任务
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("insertTask")
    @ApiOperation("单独新增拜访任务")
    public TwOutputUtil insertTask(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.insertTask(payload));
    }

    /**
     * 业务伙伴管理-新增 (访销任务 绑定客户)
     *
     * @folder 业务伙伴管理
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("businessPartner")
    @ApiOperation("业务伙伴管理-新增(访销任务 绑定客户)")
    public TwOutputUtil<BusinessPartnerVO> businessPartnerInsert(@RequestBody BusinessPartnerForVisitTaskPayload payload){
        return TwOutputUtil.ok(visitTaskService.businessPartnerInsert(payload));
    }


    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.update(payload));
    }

    /**
     * 领导评价
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("leaderEval")
    @ApiOperation("领导评价")
    public TwOutputUtil leaderEval(@RequestBody VisitTaskPayload payload) {
        return TwOutputUtil.ok(visitTaskService.leaderEval(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(visitTaskService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(VisitTaskQuery query) {
        query.setPermissionFlag(true);
        return TwOutputUtil.ok(visitTaskService.queryPaging(query));
    }

    /**
     * 我的拜访任务-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/my/paging")
    @UdcNameClass
    @ApiOperation("我的拜访任务-分页")
    public TwOutputUtil myPaging(VisitTaskQuery query) {
        return TwOutputUtil.ok(visitTaskService.myQueryPaging(query));
    }

    @GetMapping("/pagingForEval")
    @UdcNameClass
    @ApiOperation("销售拜访任务-待评价分页")
    public TwOutputUtil pagingForEval(VisitTaskQuery query) {
        // 实时查询下级
        // 查找下级
//        final Set<Long> subordinatesIdsByUserId = prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(GlobalUtil.getLoginUserId());
//        if (CollectionUtils.isEmpty(subordinatesIdsByUserId)) {
//            return TwOutputUtil.ok(Collections.EMPTY_LIST);
//        }
//        query.setEvalSubordinatesIds(subordinatesIdsByUserId);

        return TwOutputUtil.ok(visitTaskService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(VisitTaskQuery query) {
        query.setPermissionFlag(true);
        return TwOutputUtil.ok(visitTaskService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        visitTaskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
