package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigDtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdLevelConfigDtlService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护明细表
 */

@RestController
@RequestMapping("/api/prdLevelConfigDtl")
@RequiredArgsConstructor
@Api(value = "级别维护明细表", tags = {"级别维护明细表"})
public class PrdLevelConfigDtlController{

    private final PrdLevelConfigDtlService prdLevelConfigDtlService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-级别维护明细表")
    public TwOutputUtil<PrdLevelConfigDtlVO> get(@PathVariable Long id) {

        PrdLevelConfigDtlVO res = prdLevelConfigDtlService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-级别维护明细表")
    public TwOutputUtil<Long> save(@RequestBody PrdLevelConfigDtlPayload prdLevelConfigDtlPayload) {

        PrdLevelConfigDtlVO res = prdLevelConfigDtlService.save(prdLevelConfigDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-级别维护明细表")
    public TwOutputUtil<Long> update(@RequestBody PrdLevelConfigDtlPayload prdLevelConfigDtlPayload) {

        PrdLevelConfigDtlVO res = prdLevelConfigDtlService.update(prdLevelConfigDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-级别维护明细表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdLevelConfigDtlService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-级别维护明细表")
    public TwOutputUtil<PagingVO<PrdLevelConfigDtlVO>> page(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        PagingVO<PrdLevelConfigDtlVO> res = prdLevelConfigDtlService.page(prdLevelConfigDtlQuery);
        return TwOutputUtil.ok(res);

    }



}

