package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力构成
 */

@Entity
@Table(name = "prd_composite_ability_struct")
@org.hibernate.annotations.Table(appliesTo = "prd_composite_ability_struct", comment = "复合能力构成")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdCompositeAbilityStructDO extends BaseModel {


    /**
     * 单项能力id
     */
    @Column(name = "individ_ability_id", columnDefinition = "bigint(20) comment '单项能力id'")
    private Long individAbilityId;

    /**
     * 单项能力name
     */
    @Column(name = "individ_ability_name", columnDefinition = "varchar(255) comment '单项能力name'")
    private String individAbilityName;

    /**
     * 单项能力级别定义id
     */
    @Column(name = "individ_ability_level_id", columnDefinition = "bigint(20) comment '单项能力级别定义id'")
    private Long individAbilityLevelId;

    /**
     * 分类名称
     */
    @Column(name = "cate_type", columnDefinition = "varchar(255) comment '分类名称'")
    private String cateType;

    /**
     * 能力id
     */
    @Column(name = "ability_id", columnDefinition = "bigint(20) comment '能力id'")
    private Long abilityId;

    /**
     * 级别明细id
     */
    @Column(name = "level_dtl_id", columnDefinition = "varchar(2000) comment '级别明细id'")
    private String levelDtlId;

    /**
     * 级别明细名称
     */
    @Column(name = "level_dtl_name", columnDefinition = "varchar(2000) comment '级别明细名称'")
    private String levelDtlName;


}

