package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


 /**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力
 */
 
@Entity
@Table(name="prd_individ_ability")
@org.hibernate.annotations.Table(appliesTo = "prd_individ_ability", comment = "单项能力")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdIndividAbilityDO extends BaseModel {


    /**
     * 能力名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '能力名称'")
    private String name;
    
    /**
     * 编号
     */
    @Column(name = "doc_no", columnDefinition = "varchar(255) comment '编号'")
    private String docNo;
    
    /**
     * 是否显示
     */
    @Column(name = "show_flag", columnDefinition = "tinyint(1) comment '是否显示'")
    private Boolean showFlag;
    
    /**
     * 分类1
     */
    @Column(name = "cate_type1", columnDefinition = "varchar(50) comment '分类1'")
    private String cateType1;
    
    /**
     * 分类2
     */
    @Column(name = "cate_type2", columnDefinition = "varchar(50) comment '分类2'")
    private String cateType2;
    
    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;
    
    /**
     * 级别id
     */
    @Column(name = "level_id", columnDefinition = "bigint(20) comment '级别id'")
    private Long levelId;
    
    /**
     * 级别名称
     */
    @Column(name = "level_name", columnDefinition = "varchar(255) comment '级别名称'")
    private String levelName;

     /**
      * 能力描述
      */
     @Column(name = "ability_desc", columnDefinition = "varchar(255) comment '能力描述'")
     private String abilityDesc;
    

}

