package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityStructPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityStructService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityStructVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdCompositeAbilityStructDO;

import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdCompositeAbilityStructRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdCompositeAbilityStructDao;

import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdCompositeAbilityStructConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力构成Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdCompositeAbilityStructServiceImpl implements PrdCompositeAbilityStructService {


    private final PrdCompositeAbilityStructDao prdCompositeAbilityStructDao;

    private final PrdCompositeAbilityStructRepo prdCompositeAbilityStructRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCompositeAbilityStructVO save(PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload) {

        checkData(prdCompositeAbilityStructPayload);
        PrdCompositeAbilityStructDO prdCompositeAbilityStructDO = new PrdCompositeAbilityStructDO();
        prdCompositeAbilityStructDO = PrdCompositeAbilityStructConvert.INSTANCE.p2d(prdCompositeAbilityStructPayload);
        PrdCompositeAbilityStructDO res = prdCompositeAbilityStructRepo.save(prdCompositeAbilityStructDO);
        return PrdCompositeAbilityStructConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCompositeAbilityStructVO update(PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload) {

        Assert.notNull(prdCompositeAbilityStructPayload.getId(), "id is null");
        PrdCompositeAbilityStructVO res = save(prdCompositeAbilityStructPayload);
        return res;

    }


    @Override
    public PrdCompositeAbilityStructVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdCompositeAbilityStructVO res = prdCompositeAbilityStructDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdCompositeAbilityStructVO> page(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        PagingVO<PrdCompositeAbilityStructVO> res = prdCompositeAbilityStructDao.page(prdCompositeAbilityStructQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdCompositeAbilityStructDao.del(ids);
        return res;

    }

    @Override
    public List<PrdCompositeAbilityStructVO> getList(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        List<PrdCompositeAbilityStructVO> res = prdCompositeAbilityStructDao.getList(prdCompositeAbilityStructQuery);
        return res;

    }

    @Override
    public Long delByAbilitId(Long id) {

        Long res = prdCompositeAbilityStructDao.delByAbilitId(id);
        return res;
    }


    /**
     * 数据校验
     *
     * @param prdCompositeAbilityStructPayload
     */
    private void checkData(PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload) {

//        if (StringUtils.isBlank(prdCompositeAbilityStructPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }


}

