package com.elitesland.tw.tw5.server.prd.humanresources.basebu.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseBuChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBuChangeTodoService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao.PrdBaseBuChangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseBuChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.repo.PrdBaseBuChangeRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdBaseBuChangeConvert;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-11-3
 * @desc : baseBu变更Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdBaseBuChangeServiceImpl implements PrdBaseBuChangeService {


    private final PrdBaseBuChangeDao prdBaseBuChangeDao;

    private final PrdBaseBuChangeRepo prdBaseBuChangeRepo;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final PrdOrgOrganizationService prdOrgOrganizationService;

    private final PrdBuChangeTodoService prdBuChangeTodoService;

    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    private final CacheUtil cacheUtil;
    private final TimesheetService timesheetService;

    private final AccReimService accReimService;

    private final CalTaskSettleService calTaskSettleService;

    private final TaskInfoService taskInfoService;

    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdBaseBuChangeVO save(PrdBaseBuChangePayload prdBaseBuChangePayload) {

        checkData(prdBaseBuChangePayload);
        // 查询是否有审批中的流程
        PrdBaseBuChangeQuery prdBaseBuChangeQuery = new PrdBaseBuChangeQuery();
        prdBaseBuChangeQuery.setProcInstStatus(ProcInstStatus.APPROVING);
        prdBaseBuChangeQuery.setUserId(prdBaseBuChangePayload.getUserId());
        Long count = prdBaseBuChangeDao.count(prdBaseBuChangeQuery);
        if (count > 0) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }
        PrdBaseBuChangeDO prdBaseBuChangeDO = new PrdBaseBuChangeDO();
        prdBaseBuChangeDO = PrdBaseBuChangeConvert.INSTANCE.p2d(prdBaseBuChangePayload);
        PrdBaseBuChangeDO res = prdBaseBuChangeRepo.save(prdBaseBuChangeDO);

        // 新增baseBu检查待办事项
        PrdBuChangeTodoPayload prdBuChangeTodoPayload = new PrdBuChangeTodoPayload();
        prdBuChangeTodoPayload.setChangeId(res.getId());
        prdBuChangeTodoService.save(prdBuChangeTodoPayload);
        // 开启工作流
        startWorkFlow(res);

        // 更新资源状态为变更中
        PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
        prdOrgEmployeePayload.setUserId(prdBaseBuChangePayload.getUserId());
        prdOrgEmployeePayload.setResourceStatus("5");
        prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
        return PrdBaseBuChangeConvert.INSTANCE.d2v(res);

    }

    public void startWorkFlow(PrdBaseBuChangeDO res) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
        // 原baseBu上级审批
        Assert.notNull(res.getOldPUserId(), "原上级用户id不能为空");
        varMaps.put("Activity_16mcrqv", res.getOldPUserId());
        // 原baseBu领导审批
        // 根据baseBu找对应的负责人
        Assert.notNull(res.getOldBuId(), "原buid不能为空");
        Long oldBuId = res.getOldBuId();
        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(oldBuId);

        varMaps.put("Activity_0xsrxe2", prdOrgOrganizationVO.getManageId());
        // 新baseBu上级审批
        Assert.notNull(res.getNewPUserId(), "新上级用户id不能为空");
        varMaps.put("Activity_1eu9loy", res.getNewPUserId());
        // 新baseBu领导审批
        // 根据新baseBu找对应的负责人
        Assert.notNull(res.getNewBuId(), "新buid不能为空");
        Long newBuId = res.getNewBuId();
        PrdOrgOrganizationVO prdOrgOrganizationVO1 = prdOrgOrganizationService.queryDetailSimpleByOrgId(newBuId);
        varMaps.put("Activity_1cjxcqq", prdOrgOrganizationVO1.getManageId());
        // 人事审批 HRD
        List<Long> hrdUserIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        varMaps.put("Activity_0hx8664", hrdUserIds);
        // 人事专员审批 EMPLOYEE_RELATIONS_SUPERVISOR EMPLOYEE_RELATIONS_SPECIALIST

        List<Long> xcUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        varMaps.put("Activity_0bubp55", xcUserIds);
        // 变更资源审批
        varMaps.put("Activity_111kevq", res.getUserId());


        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                HrBaseEnum.BASE_BU_CHANGE.getCode(),
                "A62.BaseBU变更流程-" + cacheUtil.getUserName(res.getUserId()),
                res.getId().toString(), varMaps));

        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();

        // 回写单据的工作流信息
        PrdBaseBuChangePayload payload = new PrdBaseBuChangePayload();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setId(res.getId());
        Long update = prdBaseBuChangeDao.update(payload);

        // 发通知给人事 平台人力资源总监  平台薪酬绩效主管
        String userName = cacheUtil.getUserName(res.getUserId());
        String oldBuName = cacheUtil.getOrgName(res.getOldBuId());
        String newBuName = cacheUtil.getOrgName(res.getNewBuId());

        String title = "BaseBU变更-"+userName;
        String content = "员工"+userName+"发起了BaseBU变更，原BaseBU："+oldBuName+"，新BaseBU为："+newBuName;
        sendMessage(res.getId(),title,content);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdBaseBuChangeVO update(PrdBaseBuChangePayload prdBaseBuChangePayload) {

        Assert.notNull(prdBaseBuChangePayload.getId(), "id is null");
        PrdBaseBuChangeVO res = save(prdBaseBuChangePayload);
        return res;

    }


    @Override
    public PrdBaseBuChangeVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdBaseBuChangeVO res = prdBaseBuChangeDao.get(id);
        if (null != res) {
            // 查询待办事项
            PrdBuChangeTodoQuery prdBuChangeTodoQuery = new PrdBuChangeTodoQuery();
            prdBuChangeTodoQuery.setChangeId(id);

            List<PrdBuChangeTodoVO> dtlList = prdBuChangeTodoService.getList(prdBuChangeTodoQuery, res.getUserId());
            // 给每个类型state赋值
            updateState(dtlList, res.getUserId());
            res.setPrdBuChangeTodoVOList(dtlList);

        }

        return res;

    }

    /**
     * 查询给每个待办事项状态判断赋最新值
     *
     * @param dtlList
     */
    @Override
    public void updateState(List<PrdBuChangeTodoVO> dtlList, Long userId) {
        Assert.notNull(userId, "userId不能为空");
        for (PrdBuChangeTodoVO prdBuChangeTodoVO : dtlList) {
            if (prdBuChangeTodoVO.getTodoTitle() == 0) {
                // 当量结算  个人中心 → 我的结算：列表中不能有状态为"新建"或"处理中"的结算单

                CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
                calTaskSettleQuery.setIncomeResId(userId);
                calTaskSettleQuery.setSettleStatusList(List.of(CalSettleStatusEnum.CREATE.getCode(), CalSettleStatusEnum.IN_PROCESS.getCode()));
                List<CalTaskSettleVO> calTaskSettleVOS = calTaskSettleService.queryListDynamic(calTaskSettleQuery);
                prdBuChangeTodoVO.setState(CollectionUtil.isNotEmpty(calTaskSettleVOS) ? 0 : 1);

            } else if (prdBuChangeTodoVO.getTodoTitle() == 1) {
                // 费用报销  个人中心 → 我的报销：列表中不能有状态为“新建”或“申请中”或“财务审核中”的报销单
                boolean bo = accReimService.myReimCheck(userId);
                prdBuChangeTodoVO.setState(bo ? 0 : 1);
            } else if (prdBuChangeTodoVO.getTodoTitle() == 2) {
                // 工时提交  截至到新Base加入时间之前的工时是否全部提交
                boolean bo = timesheetService.checkTimeSheetStatueInCreateAndRejected(null, LocalDate.now(), userId);
                prdBuChangeTodoVO.setState(bo ? 0 : 1);

            } else if (prdBuChangeTodoVO.getTodoTitle() == 3) {
                // 任务包处理 任务管理 → 接受的任务：列表中不能有状态为"关闭"以外的任务
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                taskInfoQuery.setTaskResId(userId);
                taskInfoQuery.setTaskStatusFlag(0);
                taskInfoQuery.setTaskStatus(TaskStatusEnum.CLOSE.getCode());
                List<TaskInfoVO> taskInfoVOS = taskInfoService.queryList(taskInfoQuery);
                prdBuChangeTodoVO.setState(CollectionUtil.isNotEmpty(taskInfoVOS) ? 0 : 1);

            }

        }
    }

    @Override
    @Transactional
    public Boolean changeByTask(Long userId, LocalDate joinDate, String param) {

        // 根据状态筛选 加入日期数据
        PrdBaseBuChangeQuery prdBaseBuChangeQuery = new PrdBaseBuChangeQuery();
        prdBaseBuChangeQuery.setProcInstStatus(ProcInstStatus.APPROVED);
        prdBaseBuChangeQuery.setNewJoinDate(joinDate);
        prdBaseBuChangeQuery.setUserId(userId);
        List<PrdBaseBuChangeVO> list = getList(prdBaseBuChangeQuery);
        for (PrdBaseBuChangeVO prdBaseBuChangeVO : list) {
            // 更新资源库中的 状态 生效日期 ，职级，
            PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
            prdOrgEmployeePayload.setResourceStatus("3");
            prdOrgEmployeePayload.setUserId(prdBaseBuChangeVO.getUserId());
            // 发薪方式
            prdOrgEmployeePayload.setSalaryMethod(prdBaseBuChangeVO.getSalaryType());
            // 发薪周期
            prdOrgEmployeePayload.setSalaryPeriod(prdBaseBuChangeVO.getSalaryCycle());
            // 合作方式
            prdOrgEmployeePayload.setCooperationMode(prdBaseBuChangeVO.getCooperateType());
            // 当量系数
            prdOrgEmployeePayload.setEqvaRatio(prdBaseBuChangeVO.getDlRatio());
            // 职级
            prdOrgEmployeePayload.setExtString1(prdBaseBuChangeVO.getJobGrade());
            prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);

            // ref 上级员工id 组织id 加入时间

            // 根据原baseBu + 用户 修改组织
            PrdOrgEmployeeRefPayload prdOrgEmployeeRefPayload = new PrdOrgEmployeeRefPayload();
            prdOrgEmployeeRefPayload.setOrgId(prdBaseBuChangeVO.getOldBuId());
            prdOrgEmployeeRefPayload.setNewOrgId(prdBaseBuChangeVO.getNewBuId());
            prdOrgEmployeeRefPayload.setUserId(prdBaseBuChangeVO.getUserId());
            prdOrgEmployeeRefPayload.setParentId(prdBaseBuChangeVO.getNewPUserId());
            prdOrgEmployeeRefPayload.setJoinDate(LocalDate.now());

            prdOrgEmployeeDAO.updateEmployeeRefByUserId(prdOrgEmployeeRefPayload);

            // bu角色
            if (StringUtils.isNotBlank(prdBaseBuChangeVO.getNewRoleId())) {

                String[] roleIds = prdBaseBuChangeVO.getNewRoleId().split(",");
                for (String str : roleIds) {
                    PrdOrgRoleDO prdOrgRoleDO = prdOrgOrganizationDAO.queryRoleByKey(Long.valueOf(str));
                    if (null == prdOrgRoleDO) {
                        throw new BusinessException("未找到该角色" + str);
                    }
                    String roleEmployees = prdOrgRoleDO.getRoleEmployees();
                    if (StringUtils.isNotBlank(roleEmployees)) {
                        // 在后面拼接 ,
                        roleEmployees = roleEmployees + ",";
                    }
                    roleEmployees = roleEmployees + prdBaseBuChangeVO.getUserId();
                    PrdOrgRolePayload prdOrgRolePayload = new PrdOrgRolePayload();
                    prdOrgRolePayload.setId(Long.valueOf(str));
                    prdOrgRolePayload.setRoleEmployees(roleEmployees);
                    long res = prdOrgOrganizationDAO.updateRole(prdOrgRolePayload);
                }
            }

        }

        return true;
    }


    @Override
    public PagingVO<PrdBaseBuChangeVO> page(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        PagingVO<PrdBaseBuChangeVO> res = prdBaseBuChangeDao.page(prdBaseBuChangeQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdBaseBuChangeDao.del(ids);
        return res;

    }

    @Override
    public List<PrdBaseBuChangeVO> getList(PrdBaseBuChangeQuery prdBaseBuChangeQuery) {

        List<PrdBaseBuChangeVO> res = prdBaseBuChangeDao.getList(prdBaseBuChangeQuery);
        return res;

    }

    @Override
    @Transactional
    public Long updateByCondition(PrdBaseBuChangePayload prdBaseBuChangePayload) {
        Long res = prdBaseBuChangeDao.update(prdBaseBuChangePayload);
        return res;
    }


    /**
     * 数据校验
     *
     * @param prdBaseBuChangePayload
     */
    private void checkData(PrdBaseBuChangePayload prdBaseBuChangePayload) {

//        if (StringUtils.isBlank(prdBaseBuChangePayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }
        Assert.notNull(prdBaseBuChangePayload.getUserId(), "用户id不能为空");
        Assert.notNull(prdBaseBuChangePayload.getOldBuId(), "OldBuId不能为空");
        Assert.notNull(prdBaseBuChangePayload.getNewBuId(), "NewBuId不能为空");


    }

    // 发通知给人事 平台人力资源总监  平台薪酬绩效主管
    public void sendMessage(Long objectId,String messageTitle,String content){
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));

        if(!CollectionUtils.isEmpty(list)){
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}

