package com.elitesland.tw.tw5.server.prd.humanresources.eval.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表
 */
 
@Entity
@Table(name="prd_evaluate_config_point")
@org.hibernate.annotations.Table(appliesTo = "prd_evaluate_config_point", comment = "评价配置点表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEvaluateConfigPointDO extends BaseModel {


     /**
      * 名称
      */
     @Column(name = "name", columnDefinition = "varchar(255) comment '名称'")
     private String name;

     /**
      * 状态
      */
     @Column(name = "state", columnDefinition = "int(11) comment '状态'")
     private Integer state;

     /**
      * 分数下限
      */
     @Column(name = "score_min", columnDefinition = "decimal(20,2) comment '分数下限'")
     private BigDecimal scoreMin;

     /**
      * 分数上限
      */
     @Column(name = "score_max", columnDefinition = "decimal(20,2) comment '分数上限'")
     private BigDecimal scoreMax;

     /**
      * 默认分数
      */
     @Column(name = "def_score", columnDefinition = "decimal(20,2) comment '默认分数'")
     private BigDecimal defScore;

     /**
      * 标准说明
      */
     @Column(name = "standard_desc", columnDefinition = "varchar(255) comment '标准说明'")
     private String standardDesc;
    

}

