package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板
 */

@RestController
@RequestMapping("/api/prdExamTemp")
@RequiredArgsConstructor
@Api(value = "绩效考核模板", tags = {"绩效考核模板"})
public class PrdExamTempController {

    private final PrdExamTempService prdExamTempService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核模板")
    public TwOutputUtil<PrdExamTempVO> get(@PathVariable Long id) {

        PrdExamTempVO res = prdExamTempService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-绩效考核模板")
    public TwOutputUtil<Long> save(@RequestBody PrdExamTempPayload prdExamTempPayload) {

        PrdExamTempVO res = prdExamTempService.save(prdExamTempPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-绩效考核模板")
    public TwOutputUtil<Long> update(@RequestBody PrdExamTempPayload prdExamTempPayload) {

        PrdExamTempVO res = prdExamTempService.update(prdExamTempPayload);
        return TwOutputUtil.ok(res.getId());

    }

    @PostMapping("updateState")
    @ApiOperation("修改-绩效考核模板")
    public TwOutputUtil<Long> updateState(@RequestBody PrdExamTempPayload prdExamTempPayload) {

        Long res = prdExamTempService.updateState(prdExamTempPayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核模板")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdExamTempService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核模板")
    public TwOutputUtil<PagingVO<PrdExamTempVO>> page(PrdExamTempQuery prdExamTempQuery) {

        PagingVO<PrdExamTempVO> res = prdExamTempService.page(prdExamTempQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("查询绩效考核模板")
    public TwOutputUtil<List<PrdExamTempVO>> getList(PrdExamTempQuery prdExamTempQuery) {
        prdExamTempQuery.setEnableFlag(true);
        List<PrdExamTempVO> res = prdExamTempService.getList(prdExamTempQuery);
        return TwOutputUtil.ok(res);

    }


}

