package com.elitesland.tw.tw5.server.prd.humanresources.personnel.callback;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.OfferEntryApplyProcPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.OfferEntryApplyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "OFFER_ENTRY" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PersonEntryWorkflowCallBackController implements WorkflowCallBack {

    private final PrdOrgPersonDAO dao;

    private final PrdInternalRecommService prdInternalRecommService;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final OfferEntryApplyDAO offerEntryApplyDAO;

    private final ResEntryExitLogService entryExitLogService;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
        Long applyId = Long.valueOf(businessKey);
        OfferEntryApplyProcPayload offerEntryApplyProcPayload = new OfferEntryApplyProcPayload();
        offerEntryApplyProcPayload.setId(applyId);
        OfferEntryApplyVO offerEntryApplyVO = offerEntryApplyDAO.queryByKey(applyId);
        prdOrgPersonPayload.setId(offerEntryApplyVO.getPersonId());
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"激活",流程状态改为未提交
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
            case INVALID://仅删除流程
                prdOrgPersonPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                offerEntryApplyProcPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                break;
            case APPROVED:
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                prdOrgPersonPayload.setApprovedTime(LocalDateTime.now());

                offerEntryApplyProcPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                offerEntryApplyProcPayload.setApprovedTime(LocalDateTime.now());

                PrdOrgEmployeeDO prdOrgEmployeeDO = dao.findEmployeeByPersonId(offerEntryApplyVO.getPersonId());
                Long employeeId = prdOrgEmployeeDO.getId();
                PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
                prdOrgEmployeePayload.setId(employeeId);
                prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                employeeDAO.updateProcessDate(prdOrgEmployeePayload);
                // 更新内推信息入职状态
                PrdInternalRecommPayload prdInternalRecommPayload = new PrdInternalRecommPayload();
                prdInternalRecommPayload.setPersonId(prdOrgPersonPayload.getId());
                prdInternalRecommPayload.setEntryFlag(true);
                Boolean res = prdInternalRecommService.updateByPersonId(prdInternalRecommPayload);

                // 保存入职记录
                ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
                resEntryExitLogPayload.setEmployeeId(employeeId);
                resEntryExitLogPayload.setEntryExitDate(offerEntryApplyVO.getEnrollDate().toString());
                resEntryExitLogPayload.setReasonType1("OFFER_ENTRY_APPLY");
                resEntryExitLogPayload.setReasonType2(offerEntryApplyVO.getEntryType());
                resEntryExitLogPayload.setResType(offerEntryApplyVO.getExtString6());
                resEntryExitLogPayload.setBookId(offerEntryApplyVO.getBookId());
                resEntryExitLogPayload.setOrgId(offerEntryApplyVO.getOrgId());
                resEntryExitLogPayload.setBaseCity(offerEntryApplyVO.getExtString5());
                resEntryExitLogPayload.setCoopType(offerEntryApplyVO.getCooperationMode());
                resEntryExitLogPayload.setJob(offerEntryApplyVO.getJobs());
                entryExitLogService.save(resEntryExitLogPayload);

                break;
            case APPROVING:
                prdOrgPersonPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                break;
        }
        offerEntryApplyDAO.updateProcStatus(offerEntryApplyProcPayload);
        dao.updateProcessDate(prdOrgPersonPayload);
        return WorkflowResult.success(null);
    }

}
