package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonAccountVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "员工账户管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/res/account")
@Slf4j
public class PersonAccountController {

    private final PersonAccountService personAccountService;

    /**
     * 查询
     *
     * @param userId userId
     * @return result
     */
    @ApiOperation("用户id查询")
    @GetMapping("/{userId}")
    @UdcNameClass
    public TwOutputUtil<List<PersonAccountVO>> findById(@PathVariable Long userId) {
        return TwOutputUtil.ok(personAccountService.findAllByUserId(userId));
    }

}
