package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = "person_account", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_account", comment = "人员-账户表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonAccountDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("账户类型")
    @Column(name = "acc_type")
    private String accType;

    @Comment("账户名称")
    @Column(name = "acc_name")
    private String accName;

    @Comment("账户状态")
    @Column(name = "acc_status")
    private String accStatus;

    @Comment("是否工资卡")
    @Column(name = "default_flag")
    private Boolean defaultFlag;

    @Comment("币种")
    @Column(name = "curr_code")
    private String currCode;

    @Comment("开户银行")
    @Column(name = "bank_name")
    private String bankName;

    @Comment("开户地")
    @Column(name = "bank_city")
    private String bankCity;

    @Comment("开户网点")
    @Column(name = "bank_branch")
    private String bankBranch;

    @Comment("开户人")
    @Column(name = "holder_name")
    private String holderName;

    @Comment("卡号")
    @Column(name = "account_no")
    private String accountNo;
}
