package com.elitesland.tw.tw5.server.prd.humanresources.resource.callback;

import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalTaskSettleDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDetailDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "RES_WITHDRAW_APPLY" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class ResWithdrawApplyWorkflowCallBackController implements WorkflowCallBack {

    private final ResWithdrawApplyDAO resWithdrawApplyDAO;

    private final ResWithdrawApplyDetailDAO detailDAO;

    private final CalTaskSettleDAO calTaskSettleDAO;

    private final CalTaskSettleService calTaskSettleService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ResWithdrawApplyPayload applyPayload = new ResWithdrawApplyPayload();
        Long applyId = Long.valueOf(payload.getBusinessKey());
        applyPayload.setId(applyId);
        // 将结算单的operate_flag设置为0
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOS = detailDAO.findAllByApplyId(applyId);
        String approve_status = null;
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"激活",流程状态改为未提交
                applyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
            case INVALID://仅删除流程
                applyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                // 删除提现数据
                applyPayload.setDeleteFlag(1);

                if(!CollectionUtils.isEmpty(withdrawApplyDetailDOS)){
                    List<Long> settleIds = withdrawApplyDetailDOS.stream().map(e -> e.getSettleId()).collect(Collectors.toList());
                    calTaskSettleDAO.updateSettleOperate(settleIds, 0);
                }
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                applyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                // 将结算单的operate_flag设置为0
                if(!CollectionUtils.isEmpty(withdrawApplyDetailDOS)){
                    List<Long> settleIds = withdrawApplyDetailDOS.stream().map(e -> e.getSettleId()).collect(Collectors.toList());
                    calTaskSettleDAO.updateSettleOperate(settleIds, 0);
                }
                break;
            case APPROVED:
                applyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                applyPayload.setApprovedTime(LocalDateTime.now());

                //结算单提现操作
                ResWithdrawApplyDO withdrawApplyDO = resWithdrawApplyDAO.findById(applyId);
                List<ResWithdrawApplyDetailDO> detailDOList = detailDAO.findAllByApplyId(applyId);
                List<Long> settleIds = detailDOList.stream().map(ResWithdrawApplyDetailDO::getSettleId).toList();
                CalTaskSettleWithdrawPayload calTaskSettleWithdrawPayload = new CalTaskSettleWithdrawPayload();
                calTaskSettleWithdrawPayload.setWithdrawId(withdrawApplyDO.getId());
                calTaskSettleWithdrawPayload.setWithdrawNo(withdrawApplyDO.getWithdrawNo());
                calTaskSettleWithdrawPayload.setWithdrawResId(withdrawApplyDO.getApplyUserId());
                calTaskSettleWithdrawPayload.setWithdrawStatus("2");
                calTaskSettleWithdrawPayload.setSettleIds(settleIds);
                calTaskSettleWithdrawPayload.setWithdrawQty(withdrawApplyDO.getWithdrawEqva());
                calTaskSettleWithdrawPayload.setWithdrawAmt(withdrawApplyDO.getWithdrawAmt());
                calTaskSettleService.taskSettleWithdraw(calTaskSettleWithdrawPayload);

                break;
            case APPROVING:
                applyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                break;
        }
        resWithdrawApplyDAO.updatePrco(applyPayload);
        return WorkflowResult.success(null);
    }
}
