package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ExternalResApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ExternalResApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ExternalResApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ExternalResApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/externalres")
@RequiredArgsConstructor
@Api(value = "外部资源", tags = {"外部资源"})
public class ExternalResApplyController {

    private final ExternalResApplyService externalResApplyService;


    /**
     * 外部资源引入申请/修改
     *
     * @param payload
     * @return result
     */
    @ApiOperation("外部资源引入申请/修改")
    @PostMapping("/apply")
    @GlobalTransactional
    public TwOutputUtil apply(@RequestBody ExternalResApplyPayload payload) {
        externalResApplyService.apply(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 外部资源引入流程详情
     *
     * @param procId
     * @return result
     */
    @ApiOperation("外部资源引入流程详情")
    @GetMapping("/apply/detail/{procId}")
    public TwOutputUtil<ExternalResApplyVO> queryByProcId(@PathVariable String procId) {
        return TwOutputUtil.ok(externalResApplyService.queryByProcId(procId));
    }

    /**
     * 外部资源引入流程详情
     *
     * @param query
     * @return result
     */
    @ApiOperation("外部资源引入分页")
    @GetMapping("/apply/page")
    @UdcNameClass
    public TwOutputUtil<PagingVO<ExternalResApplyVO>> queryByProcId(ExternalResApplyQuery query) {
        return TwOutputUtil.ok(externalResApplyService.ExternalResApplyPage(query));
    }
    
}
