package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResWithdrawApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyInfo;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/res/withdraw")
@RequiredArgsConstructor
@Api(value = "资源提现", tags = {"资源提现"})
public class ResWithdrawApplyController {

    private final ResWithdrawApplyService service;

    /**
     * 资源提现申请
     *
     * @param payload
     * @return result
     */
    @ApiOperation("资源提现申请")
    @PostMapping("/apply")
    @GlobalTransactional
    public TwOutputUtil apply(@RequestBody ResWithdrawApplyPayload payload) {
        service.submit(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 资源提现申请详情
     *
     * @param procId
     * @return result
     */
    @ApiOperation("资源提现申请详情")
    @GetMapping("/query/{procId}")
    public TwOutputUtil<ResWithdrawApplyVO> query(@PathVariable String procId) {

        return TwOutputUtil.ok(service.queryByProcId(procId));
    }

    /**
     * 资源提现列表-分页
     *
     * @param query
     * @return result
     */
    @ApiOperation("资源提现列表-分页")
    @GetMapping("/page")
    @UdcNameClass
    public TwOutputUtil<PagingVO<ResWithdrawApplyVO>> page(ResWithdrawApplyQuery query) {

        return TwOutputUtil.ok(service.page(query));
    }

    /**
     * 资源提现列表详情
     *
     * @param id
     * @return result
     */
    @ApiOperation("资源提现列表详情")
    @GetMapping("/get/{id}")
    public TwOutputUtil<ResWithdrawApplyVO> queryByKey(@PathVariable Long id) {

        return TwOutputUtil.ok(service.queryByKey(id));
    }

    /**
     * 资源提现列表-分页(付款查询)
     *
     * @param query
     * @return result
     */
    @ApiOperation("资源提现列表-分页(付款查询)")
    @GetMapping("/pageTotal")
    @UdcNameClass
    public TwOutputUtil<ResWithdrawApplyInfo> pageTotal(ResWithdrawApplyQuery query) {

        return TwOutputUtil.ok(service.getResWithdrawTotal(query));
    }

}
