package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "res_portrayal_eval_config")
@org.hibernate.annotations.Table(appliesTo = "res_portrayal_eval_config", comment = "资源画像评价配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ResPortrayalEvalConfigDO extends BaseModel {

    @Comment("资源userId")
    @Column()
    private Long userId;

    @Comment("关联评价点id集合")
    @Column()
    private String evalPointIds;

    @Comment("是否默认评价点")
    @Column()
    private Boolean defaultFlag;

}
