package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResWithdrawApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyInfo;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ResWithdrawApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ResWithdrawApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDetailDO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class ResWithdrawApplyServiceImpl extends BaseServiceImpl implements ResWithdrawApplyService {

    private final CacheUtil cacheUtil;

    private final PrdSystemRoleService prdSystemRoleService;

    private final ResWithdrawApplyDAO resWithdrawApplyDAO;

    private final ResWithdrawApplyDetailDAO resWithdrawApplyDetailDAO;

    private final WorkflowUtil workflowUtil;

    private final CalTaskSettleService calTaskSettleService;


    @Override
    @Transactional
    public void submit(ResWithdrawApplyPayload payload) {
        if (payload.getProcInstId() == null) {
            startProc(payload);
        } else {
            updateWithdrawApply(payload);
        }

    }

    public void startProc(ResWithdrawApplyPayload payload) {

        ResWithdrawApplyDO payDO = ResWithdrawApplyConvert.INSTANCE.payloadToDo(payload);
        String withdrawApplyNo = generateSeqNum("RES_WITHDRAW_APPLY_NO");
        payDO.setWithdrawNo(withdrawApplyNo);
        List<ResWithdrawApplyDetailPayload> withdrawApplyDetailPayloadList = payload.getDetailPayloadList();
        BigDecimal withdrawAmt = new BigDecimal(0);
        BigDecimal withdrawEqva = new BigDecimal(0);
        for (ResWithdrawApplyDetailPayload detailPayload : withdrawApplyDetailPayloadList) {
            withdrawAmt = withdrawAmt.add(detailPayload.getAvalAmt());
            withdrawEqva = withdrawEqva.add(detailPayload.getAvalQty());
        }
        payDO.setWithdrawAmt(withdrawAmt);
        payDO.setWithdrawEqva(withdrawEqva);
        Long applyUserId = GlobalUtil.getLoginUserId();
        ResWithdrawApplyDO resWithdrawApplyDO = resWithdrawApplyDAO.save(payDO);
        List<ResWithdrawApplyDetailDO> resWithdrawApplyDetailDOList = ResWithdrawApplyDetailConvert.INSTANCE.payloadsToDos(withdrawApplyDetailPayloadList);
        resWithdrawApplyDetailDOList.forEach(resWithdrawApplyDetailDO -> resWithdrawApplyDetailDO.setApplyId(resWithdrawApplyDO.getId()));
        resWithdrawApplyDetailDAO.saveAll(resWithdrawApplyDetailDOList);

        List<Long> settleIds = withdrawApplyDetailPayloadList.stream().map(ResWithdrawApplyDetailPayload::getSettleId).toList();
        CalTaskSettleWithdrawPayload calTaskSettleWithdrawPayload = new CalTaskSettleWithdrawPayload();
        calTaskSettleWithdrawPayload.setWithdrawId(resWithdrawApplyDO.getId());
        calTaskSettleWithdrawPayload.setWithdrawNo(withdrawApplyNo);
        calTaskSettleWithdrawPayload.setWithdrawResId(applyUserId);
        calTaskSettleWithdrawPayload.setWithdrawStatus("1");
        calTaskSettleWithdrawPayload.setSettleIds(settleIds);
        calTaskSettleWithdrawPayload.setWithdrawQty(resWithdrawApplyDO.getWithdrawEqva());
        calTaskSettleWithdrawPayload.setWithdrawAmt(resWithdrawApplyDO.getWithdrawAmt());
        calTaskSettleService.taskSettleWithdraw(calTaskSettleWithdrawPayload);

        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();

        Long currentUserId = GlobalUtil.getLoginUserId();
        HashMap<String, Object> variables = new HashMap<>();
        PrdOrgEmployeeRefVO refVO = cacheUtil.getUserDefaultOrg(currentUserId);
        PrdOrgEmployeeVO employeeVO = cacheUtil.getEmployee(currentUserId);
        //上级审批
        variables.put("Activity_1ro83hm", CollUtil.newArrayList(refVO.getParentId()));
        //资源总监审批
        List<Long> resDirectors = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
        variables.put("Activity_1gj69zo", resDirectors);
        //BU负责人审批
        variables.put("Activity_1n1w2bd", CollUtil.newArrayList(refVO.getManageId()));
        //平台财务负责人审批
        List<Long> finLeaderIds = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_PIC.getCode());
        variables.put("Activity_1viykwl", CollUtil.newArrayList(finLeaderIds));
        //HR审批
        List<Long> salaryManageIds = prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode());
        variables.put("Activity_1k04zqt", CollUtil.newArrayList(salaryManageIds));

        variables.put("innerTypeFlag", employeeVO.getExtString6().equals("INTERNAL_RES"));

        processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.RES_WITHDRAW_APPLY.name(),
                employeeVO.getEmployeeName() + "-提现申请流程",
                resWithdrawApplyDO.getId() + "",
                variables)
        );

        //流程启动成功后，回写业务表数据
        payload.setId(resWithdrawApplyDO.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        resWithdrawApplyDAO.updatePrco(payload);
    }

    public void updateWithdrawApply(ResWithdrawApplyPayload payload) {

        ResWithdrawApplyDO payDO = ResWithdrawApplyConvert.INSTANCE.payloadToDo(payload);
        List<ResWithdrawApplyDetailPayload> withdrawApplyDetailPayloadList = payload.getDetailPayloadList();
        BigDecimal withdrawAmt = new BigDecimal(0);
        BigDecimal withdrawEqva = new BigDecimal(0);
        BigDecimal adjWithdrawAmt = new BigDecimal(0);
        for (ResWithdrawApplyDetailPayload detailPayload : withdrawApplyDetailPayloadList) {
            withdrawAmt = withdrawAmt.add(detailPayload.getAvalAmt());
            withdrawEqva = withdrawEqva.add(detailPayload.getAvalQty());
            adjWithdrawAmt = adjWithdrawAmt.add(detailPayload.getAdjWithdrawAmt());
        }
        payDO.setWithdrawAmt(withdrawAmt);
        payDO.setWithdrawEqva(withdrawEqva);
        payDO.setAdjWithdrawAmt(adjWithdrawAmt);
        ResWithdrawApplyDO resWithdrawApplyDO = resWithdrawApplyDAO.save(payDO);
        Long applyId = resWithdrawApplyDO.getId();
        List<ResWithdrawApplyDetailDO> resWithdrawApplyDetailDOList = ResWithdrawApplyDetailConvert.INSTANCE.payloadsToDos(withdrawApplyDetailPayloadList);
        resWithdrawApplyDetailDOList.forEach(resWithdrawApplyDetailDO -> resWithdrawApplyDetailDO.setApplyId(applyId));
        resWithdrawApplyDetailDAO.deleteAllByApplyId(applyId);
        resWithdrawApplyDetailDAO.saveAll(resWithdrawApplyDetailDOList);
    }

    @Override
    public ResWithdrawApplyVO queryByProcId(String procId) {

        ResWithdrawApplyDO withdrawApplyDO = resWithdrawApplyDAO.findByProcId(procId);
        ResWithdrawApplyVO withdrawApplyVO = ResWithdrawApplyConvert.INSTANCE.doToVo(withdrawApplyDO);
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOList = resWithdrawApplyDetailDAO.findAllByApplyId(withdrawApplyDO.getId());
        List<ResWithdrawApplyDetailVO> withdrawApplyDetailVOList = ResWithdrawApplyDetailConvert.INSTANCE.dosToVos(withdrawApplyDetailDOList);
        withdrawApplyVO.setDetailVOList(withdrawApplyDetailVOList);
        return withdrawApplyVO;
    }

    @Override
    public PagingVO<ResWithdrawApplyVO> page(ResWithdrawApplyQuery query) {

        return resWithdrawApplyDAO.queryPaging(query);

    }

    @Override
    public ResWithdrawApplyInfo getResWithdrawTotal(ResWithdrawApplyQuery query) {
        ResWithdrawApplyInfo resWithdrawApplyInfo = new ResWithdrawApplyInfo();
        PagingVO<ResWithdrawApplyVO> resWithdrawApplyVOPagingVO = resWithdrawApplyDAO.queryPaging(query);
        resWithdrawApplyInfo.setResWithdrawApplyPageVO(resWithdrawApplyVOPagingVO);
        BigDecimal withdrawEqvaTotal = resWithdrawApplyDAO.getWithdrawEqvaTotal(query);
        BigDecimal withdrawAmtTotal = resWithdrawApplyDAO.getWithdrawAmtTotal(query);
        resWithdrawApplyInfo.setWithdrawAmt(withdrawAmtTotal);
        resWithdrawApplyInfo.setWithdrawEqva(withdrawEqvaTotal);
        // udc不管用 手动翻译系统选择项
        this.translate(resWithdrawApplyVOPagingVO.getRecords());
        return resWithdrawApplyInfo;
    }

    /**
     * 翻译合作方式、提现付款状态
     *
     * @param records 要翻译的VO
     */
    private void translate(List<ResWithdrawApplyVO> records) {
        records.forEach(resWithdrawApplyVO -> {
            resWithdrawApplyVO.setCooperationModeName(cacheUtil.transferSystemSelection("org:employee:COOPERATION_MODE", resWithdrawApplyVO.getCooperationMode()));
            resWithdrawApplyVO.setWithdrawPayStatusName(cacheUtil.transferSystemSelection("org:employee:withdrawPayStatus", resWithdrawApplyVO.getWithdrawPayStatus()));
            resWithdrawApplyVO.setApplyUserName(cacheUtil.getUserName(resWithdrawApplyVO.getApplyUserId()));
        });
    }


    @Override
    public ResWithdrawApplyVO queryByKey(Long id) {
        ResWithdrawApplyDO withdrawApplyDO = resWithdrawApplyDAO.findById(id);
        ResWithdrawApplyVO withdrawApplyVO = ResWithdrawApplyConvert.INSTANCE.doToVo(withdrawApplyDO);
        withdrawApplyVO.setApplyUserName(cacheUtil.getUserName(withdrawApplyDO.getApplyUserId()));
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOList = resWithdrawApplyDetailDAO.findAllByApplyId(withdrawApplyDO.getId());
        List<ResWithdrawApplyDetailVO> withdrawApplyDetailVOList = ResWithdrawApplyDetailConvert.INSTANCE.dosToVos(withdrawApplyDetailDOList);
        for (ResWithdrawApplyDetailVO resWithdrawApplyDetailVO : withdrawApplyDetailVOList) {
            CalTaskSettleVO calTaskSettleVO = calTaskSettleService.queryByKey(resWithdrawApplyDetailVO.getSettleId());
            if (!ObjectUtils.isEmpty(calTaskSettleVO)) {
                resWithdrawApplyDetailVO.setProjName(calTaskSettleVO.getProjName());
                resWithdrawApplyDetailVO.setTaskName(calTaskSettleVO.getTaskName());
                resWithdrawApplyDetailVO.setSettleNo(calTaskSettleVO.getSettleNo());
            }
        }
        withdrawApplyVO.setDetailVOList(withdrawApplyDetailVOList);
        return withdrawApplyVO;
    }

    @Override
    public List<ResWithdrawApplyVO> findWithdrawByAgreementNo(String agreementNo) {
        return resWithdrawApplyDAO.findWithdrawByAgreementNo(agreementNo);
    }

    @Override
    public void updateWithdrawStatusAndPaymentApplyIdByIds(Long paymentApplyId, List<Long> withdrawIds, String withdrawStatus) {
        resWithdrawApplyDAO.updateWithdrawStatusAndPaymentApplyIdByIds(paymentApplyId, withdrawIds, withdrawStatus);
    }

    @Override
    public void updateWithdrawStatusByPaymentApplyId(Long paymentApplyId, String withdrawStatus) {
        // 将提现申请单状态、付款申请单id恢复
        if (withdrawStatus == null) {
            resWithdrawApplyDAO.resetWithdrawByPaymentApplyId(paymentApplyId);
        } else {
            // 修改状态
            resWithdrawApplyDAO.updateWithdrawStatusByPaymentApplyId(paymentApplyId, withdrawStatus);
        }
    }

    @Override
    public List<ResWithdrawApplyVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return resWithdrawApplyDAO.queryListByPaymentApplyId(paymentApplyId);
    }
}
