package com.elitesland.tw.tw5.server.prd.inv.controller;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceTravelItineraryPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceTravelItineraryQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceTravelItineraryService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceTravelItineraryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票行程单
 *
 * @author zoey
 * @date 2023-12-05
 */
@Api(tags = "发票行程单")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/invInvoiceTravelItinerary")
@Slf4j
public class InvInvoiceTravelItineraryController {

private final InvInvoiceTravelItineraryService invInvoiceTravelItineraryService;

    /**
     * 发票行程单-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票行程单-新增")
    public TwOutputUtil<InvInvoiceTravelItineraryVO> insert(@RequestBody InvInvoiceTravelItineraryPayload payload){
         return TwOutputUtil.ok(invInvoiceTravelItineraryService.insert(payload));
    }

    /**
     * 发票行程单-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票行程单-更新")
    public TwOutputUtil<InvInvoiceTravelItineraryVO> update(@RequestBody InvInvoiceTravelItineraryPayload payload){
        return TwOutputUtil.ok(invInvoiceTravelItineraryService.update(payload));
    }

    /**
     * 发票行程单-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票行程单-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvInvoiceTravelItineraryPayload payload){
        return TwOutputUtil.ok(invInvoiceTravelItineraryService.updateByKeyDynamic(payload));
    }

    /**
     * 发票行程单-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票行程单-主键查询")
    public TwOutputUtil<InvInvoiceTravelItineraryVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invInvoiceTravelItineraryService.queryByKey(key));
    }

    /**
     * 发票行程单-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票行程单-分页")
    public TwOutputUtil<PagingVO<InvInvoiceTravelItineraryVO>> paging(InvInvoiceTravelItineraryQuery query) {
        return TwOutputUtil.ok(invInvoiceTravelItineraryService.queryPaging(query));
    }

    /**
     * 发票行程单-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票行程单-查询列表")
    public TwOutputUtil<List<InvInvoiceTravelItineraryVO>> queryList(InvInvoiceTravelItineraryQuery query) {
        return TwOutputUtil.ok(invInvoiceTravelItineraryService.queryListDynamic(query));
    }

    /**
     * 发票行程单-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票行程单-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invInvoiceTravelItineraryService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

