package com.elitesland.tw.tw5.server.prd.inv.dao;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDetailDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvInvoiceDetailDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Repository
@RequiredArgsConstructor
public class InvInvoiceDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final InvInvoiceDetailRepo repo;
    private final QInvInvoiceDetailDO qdo = QInvInvoiceDetailDO.invInvoiceDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(InvInvoiceDetailVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 租户ID
                qdo.tenantId,
                // 发票ID
                qdo.invId,
                // 百望系统发票ID
                qdo.baiwangInvId,
                // 百望系统发票明细表ID
                qdo.baiwangId,
                // 行号:通用行号
                qdo.rowNo,
                // 商品编码:通用商品编码
                qdo.commodityCode,
                // 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目
                qdo.commodityName,
                // 规格型号:专普电（不含通行费）
                qdo.specificationModel,
                // 单位:单位
                qdo.unit,
                // 数量:数量
                qdo.quantity,
                // 单价:单价
                qdo.unitPrice,
                // 金额:金额
                qdo.amount,
                // 税率:税率
                qdo.taxRate,
                // 税额:税额
                qdo.tax,
                // 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss
                qdo.currentDateStart,
                // 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss
                qdo.currentDateEnd,
                // 车牌号:车牌号
                qdo.licensePlateNum,
                // 类型:类型，明细中的类型，商品类型
                qdo.goodsType,
                // 类型:类型，明细中的类型，商品类型
                qdo.detailType,
                // 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率
                qdo.specialMark,
                // 是否删除:是否删除，0-否，1-是
                qdo.isDel
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceDetailVO> getJpaQueryWhere(InvInvoiceDetailQuery query) {
        JPAQuery<InvInvoiceDetailVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(InvInvoiceDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(InvInvoiceDetailQuery query){
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvId())) {
            list.add(qdo.invId.eq(query.getInvId()));
        }
        /** 发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvIds())) {
            list.add(qdo.invId.in(query.getInvIds()));
        }
        /** 百望系统发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangInvId())) {
            list.add(qdo.baiwangInvId.eq(query.getBaiwangInvId()));
        }
        /** 百望系统发票明细表ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangId())) {
            list.add(qdo.baiwangId.eq(query.getBaiwangId()));
        }
        /** 行号:通用行号 精确 */
        if (!ObjectUtils.isEmpty(query.getRowNo())) {
            list.add(qdo.rowNo.eq(query.getRowNo()));
        }
        /** 商品编码:通用商品编码 精确 */
        if (!ObjectUtils.isEmpty(query.getCommodityCode())) {
            list.add(qdo.commodityCode.eq(query.getCommodityCode()));
        }
        /** 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目 精确 */
        if (!ObjectUtils.isEmpty(query.getCommodityName())) {
            list.add(qdo.commodityName.eq(query.getCommodityName()));
        }
        /** 规格型号:专普电（不含通行费） 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecificationModel())) {
            list.add(qdo.specificationModel.eq(query.getSpecificationModel()));
        }
        /** 单位:单位 精确 */
        if (!ObjectUtils.isEmpty(query.getUnit())) {
            list.add(qdo.unit.eq(query.getUnit()));
        }
        /** 数量:数量 精确 */
        if (!ObjectUtils.isEmpty(query.getQuantity())) {
            list.add(qdo.quantity.eq(query.getQuantity()));
        }
        /** 单价:单价 精确 */
        if (!ObjectUtils.isEmpty(query.getUnitPrice())) {
            list.add(qdo.unitPrice.eq(query.getUnitPrice()));
        }
        /** 金额:金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmount())) {
            list.add(qdo.amount.eq(query.getAmount()));
        }
        /** 税率:税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 税额:税额 精确 */
        if (!ObjectUtils.isEmpty(query.getTax())) {
            list.add(qdo.tax.eq(query.getTax()));
        }
        /** 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrentDateStart())) {
            list.add(qdo.currentDateStart.eq(query.getCurrentDateStart()));
        }
        /** 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrentDateEnd())) {
            list.add(qdo.currentDateEnd.eq(query.getCurrentDateEnd()));
        }
        /** 车牌号:车牌号 精确 */
        if (!ObjectUtils.isEmpty(query.getLicensePlateNum())) {
            list.add(qdo.licensePlateNum.eq(query.getLicensePlateNum()));
        }
        /** 类型:类型，明细中的类型，商品类型 精确 */
        if (!ObjectUtils.isEmpty(query.getGoodsType())) {
            list.add(qdo.goodsType.eq(query.getGoodsType()));
        }
        /** 类型:类型，明细中的类型，商品类型 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailType())) {
            list.add(qdo.detailType.eq(query.getDetailType()));
        }
        /** 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率 精确 */
        if (!ObjectUtils.isEmpty(query.getSpecialMark())) {
            list.add(qdo.specialMark.eq(query.getSpecialMark()));
        }
        /** 是否删除:是否删除，0-否，1-是 精确 */
        if (!ObjectUtils.isEmpty(query.getIsDel())) {
            list.add(qdo.isDel.eq(query.getIsDel()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public InvInvoiceDetailVO queryByKey(Long id) {
        JPAQuery<InvInvoiceDetailVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<InvInvoiceDetailVO> queryListDynamic(InvInvoiceDetailQuery query) {
        JPAQuery<InvInvoiceDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<InvInvoiceDetailVO> queryPaging(InvInvoiceDetailQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<InvInvoiceDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<InvInvoiceDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<InvInvoiceDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public InvInvoiceDetailDO save(InvInvoiceDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<InvInvoiceDetailDO> saveAll(List<InvInvoiceDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(InvInvoiceDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 发票ID
        if (payload.getInvId() != null) {
            update.set(qdo.invId, payload.getInvId());
        }
        // 百望系统发票ID
        if (payload.getBaiwangInvId() != null) {
            update.set(qdo.baiwangInvId, payload.getBaiwangInvId());
        }
        // 百望系统发票明细表ID
        if (payload.getBaiwangId() != null) {
            update.set(qdo.baiwangId, payload.getBaiwangId());
        }
        // 行号:通用行号
        if (payload.getRowNo() != null) {
            update.set(qdo.rowNo, payload.getRowNo());
        }
        // 商品编码:通用商品编码
        if (payload.getCommodityCode() != null) {
            update.set(qdo.commodityCode, payload.getCommodityCode());
        }
        // 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目
        if (payload.getCommodityName() != null) {
            update.set(qdo.commodityName, payload.getCommodityName());
        }
        // 规格型号:专普电（不含通行费）
        if (payload.getSpecificationModel() != null) {
            update.set(qdo.specificationModel, payload.getSpecificationModel());
        }
        // 单位:单位
        if (payload.getUnit() != null) {
            update.set(qdo.unit, payload.getUnit());
        }
        // 数量:数量
        if (payload.getQuantity() != null) {
            update.set(qdo.quantity, payload.getQuantity());
        }
        // 单价:单价
        if (payload.getUnitPrice() != null) {
            update.set(qdo.unitPrice, payload.getUnitPrice());
        }
        // 金额:金额
        if (payload.getAmount() != null) {
            update.set(qdo.amount, payload.getAmount());
        }
        // 税率:税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 税额:税额
        if (payload.getTax() != null) {
            update.set(qdo.tax, payload.getTax());
        }
        // 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss
        if (payload.getCurrentDateStart() != null) {
            update.set(qdo.currentDateStart, payload.getCurrentDateStart());
        }
        // 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss
        if (payload.getCurrentDateEnd() != null) {
            update.set(qdo.currentDateEnd, payload.getCurrentDateEnd());
        }
        // 车牌号:车牌号
        if (payload.getLicensePlateNum() != null) {
            update.set(qdo.licensePlateNum, payload.getLicensePlateNum());
        }
        // 类型:类型，明细中的类型，商品类型
        if (payload.getGoodsType() != null) {
            update.set(qdo.goodsType, payload.getGoodsType());
        }
        // 类型:类型，明细中的类型，商品类型
        if (payload.getDetailType() != null) {
            update.set(qdo.detailType, payload.getDetailType());
        }
        // 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率
        if (payload.getSpecialMark() != null) {
            update.set(qdo.specialMark, payload.getSpecialMark());
        }
        // 是否删除:是否删除，0-否，1-是
        if (payload.getIsDel() != null) {
            update.set(qdo.isDel, payload.getIsDel());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 租户ID
            if (nullFields.contains("tenantId")) {
                update.setNull(qdo.tenantId);
            }
            // 发票ID
            if (nullFields.contains("invId")) {
                update.setNull(qdo.invId);
            }
            // 百望系统发票ID
            if (nullFields.contains("baiwangInvId")) {
                update.setNull(qdo.baiwangInvId);
            }
            // 百望系统发票明细表ID
            if (nullFields.contains("baiwangId")) {
                update.setNull(qdo.baiwangId);
            }
            // 行号:通用行号
            if (nullFields.contains("rowNo")) {
                update.setNull(qdo.rowNo);
            }
            // 商品编码:通用商品编码
            if (nullFields.contains("commodityCode")) {
                update.setNull(qdo.commodityCode);
            }
            // 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目
            if (nullFields.contains("commodityName")) {
                update.setNull(qdo.commodityName);
            }
            // 规格型号:专普电（不含通行费）
            if (nullFields.contains("specificationModel")) {
                update.setNull(qdo.specificationModel);
            }
            // 单位:单位
            if (nullFields.contains("unit")) {
                update.setNull(qdo.unit);
            }
            // 数量:数量
            if (nullFields.contains("quantity")) {
                update.setNull(qdo.quantity);
            }
            // 单价:单价
            if (nullFields.contains("unitPrice")) {
                update.setNull(qdo.unitPrice);
            }
            // 金额:金额
            if (nullFields.contains("amount")) {
                update.setNull(qdo.amount);
            }
            // 税率:税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 税额:税额
            if (nullFields.contains("tax")) {
                update.setNull(qdo.tax);
            }
            // 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss
            if (nullFields.contains("currentDateStart")) {
                update.setNull(qdo.currentDateStart);
            }
            // 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss
            if (nullFields.contains("currentDateEnd")) {
                update.setNull(qdo.currentDateEnd);
            }
            // 车牌号:车牌号
            if (nullFields.contains("licensePlateNum")) {
                update.setNull(qdo.licensePlateNum);
            }
            // 类型:类型，明细中的类型，商品类型
            if (nullFields.contains("goodsType")) {
                update.setNull(qdo.goodsType);
            }
            // 类型:类型，明细中的类型，商品类型
            if (nullFields.contains("detailType")) {
                update.setNull(qdo.detailType);
            }
            // 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率
            if (nullFields.contains("specialMark")) {
                update.setNull(qdo.specialMark);
            }
            // 是否删除:是否删除，0-否，1-是
            if (nullFields.contains("isDel")) {
                update.setNull(qdo.isDel);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

