package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.OutWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.OutWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.OutWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.OutWorkApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 外勤办公申请
 *
 * @author carl
 * @date 2024-05-22
 */
@Api(tags = "外勤办公申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/outWorkApply")
@Slf4j
public class OutWorkApplyController {

    private final OutWorkApplyService outWorkApplyService;

    /**
     * 外勤办公申请-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("外勤办公申请-新增或修改")
    public TwOutputUtil<OutWorkApplyVO> insertOrUpdate(@RequestBody OutWorkApplyPayload payload) {
        return TwOutputUtil.ok(outWorkApplyService.insertOrUpdate(payload));
    }

//    /**
//     * 外勤办公申请-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("外勤办公申请-更新")
//    public TwOutputUtil<OutWorkApplyVO> update(@RequestBody OutWorkApplyPayload payload){
//        return TwOutputUtil.ok(outWorkApplyService.update(payload));
//    }

    /**
     * 外勤办公申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("外勤办公申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody OutWorkApplyPayload payload) {
        return TwOutputUtil.ok(outWorkApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 外勤办公申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("外勤办公申请-主键查询")
    public TwOutputUtil<OutWorkApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(outWorkApplyService.queryByKey(key));
    }

    /**
     * 外勤办公申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("外勤办公申请-分页")
    public TwOutputUtil<PagingVO<OutWorkApplyVO>> paging(OutWorkApplyQuery query) {
        return TwOutputUtil.ok(outWorkApplyService.queryPaging(query));
    }

    /**
     * 外勤办公申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("外勤办公申请-查询列表")
    public TwOutputUtil<List<OutWorkApplyVO>> queryList(OutWorkApplyQuery query) {
        return TwOutputUtil.ok(outWorkApplyService.queryListDynamic(query));
    }

    /**
     * 外勤办公申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("外勤办公申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        outWorkApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

