package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


@Api(tags = "奖励假配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/rewardLeaveConfig")
@Slf4j
public class RewardLeaveConfigController {

    private final RewardLeaveConfigService rewardLeaveConfigService;

    /**
     * 奖励假配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("奖励假配置-新增")
    public TwOutputUtil<RewardLeaveConfigVO> insert(@RequestBody RewardLeaveConfigPayload payload) {
        return TwOutputUtil.ok(rewardLeaveConfigService.insert(payload));
    }

    /**
     * 奖励假配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("奖励假配置-更新")
    public TwOutputUtil<RewardLeaveConfigVO> update(@RequestBody RewardLeaveConfigPayload payload) {
        return TwOutputUtil.ok(rewardLeaveConfigService.update(payload));
    }

    /**
     * 奖励假配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("奖励假配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody RewardLeaveConfigPayload payload) {
        return TwOutputUtil.ok(rewardLeaveConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 奖励假配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("奖励假配置-主键查询")
    public TwOutputUtil<RewardLeaveConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(rewardLeaveConfigService.queryByKey(key));
    }

    /**
     * 奖励假配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("奖励假配置-分页")
    public TwOutputUtil<PagingVO<RewardLeaveConfigVO>> paging(RewardLeaveConfigQuery query) {
        return TwOutputUtil.ok(rewardLeaveConfigService.queryPaging(query));
    }

    /**
     * 奖励假配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("奖励假配置-查询列表")
    public TwOutputUtil<List<RewardLeaveConfigVO>> queryList(RewardLeaveConfigQuery query) {
        return TwOutputUtil.ok(rewardLeaveConfigService.queryListDynamic(query));
    }

    /**
     * 奖励假配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("奖励假配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        rewardLeaveConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}


