package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.vo.ResProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 工时用-任务表
 *
 * @author duwh
 * @date 2022-12-09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/task")
@Slf4j
@Deprecated
public class TaskController {

    private final TaskService taskService;

    private final ResActivityService resActivityService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TaskPayload payload) {
        return TwOutputUtil.ok(taskService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody TaskPayload payload) {
        return TwOutputUtil.ok(taskService.update(payload));
    }

    /**
     * 更新,当4.0流程申请完成后，会调用此方法更新5.0的任务状态
     *
     * @param taskId 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/updateTaskStatus")
    public TwOutputUtil updateTaskStatus(Long taskId, String status) {
        return TwOutputUtil.ok(taskService.updateTaskStatus(taskId, status));
    }

    /**
     * 更新,当4.0发包人审批，会调用此方法更新5.0的任务事由信息以及费用承担BU
     *
     * @param taskId 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/updateTaskReason")
    public TwOutputUtil updateTaskReason(Long taskId, String reasonType, Long reasonId, Long expenseBuId) {
        return TwOutputUtil.ok(taskService.updateTaskReason(taskId, reasonType, reasonId, expenseBuId));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(TaskQuery query) {
        return TwOutputUtil.ok(taskService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(TaskQuery query) {
        return TwOutputUtil.ok(taskService.queryList(query));
    }

    /**
     * 根据项目主键 查询任务列表
     * 0 无项目情况
     *
     * @param projIdV4 项目id v4
     * @param test     测试阶段 忽略接包人是自己的
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listFortimesheet")
    public TwOutputUtil selectTaskForTimesheet(Long projIdV4, boolean test) {
        if (null == projIdV4) {
            return TwOutputUtil.error("999", "缺少参数", null);
        }
        TaskQuery query = new TaskQuery();
        List<TaskVO> timesheetViews = taskService.selectTaskForTimesheet(query, projIdV4, test);
        return TwOutputUtil.ok(timesheetViews);
    }

    /**
     * 根据默认任务，去查询该项目对应的活动
     * 0 无项目情况
     *
     * @param projIdV4 项目id v4
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/findActivityByDefaultTask")
    public TwOutputUtil findActivityByDefaultTask(Long projIdV4, String workDate) {
        if (null == projIdV4) {
            return TwOutputUtil.error("999", "缺少参数", null);
        }
        List<ResProjectActivityVO> resActivityViews = resActivityService.selectActivityByDefaultTask(projIdV4, workDate);
        return TwOutputUtil.ok(resActivityViews);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }



    /**
     * 获取项目相关发包人
     *
     * @param projectId 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/getDisterUserId/{projectId}")
    public TwOutputUtil getDisterUserIds(@PathVariable Long projectId) {
        return TwOutputUtil.ok(taskService.getDisterUserIds(projectId));
    }

}
