package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetSubsidySettingPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetSubsidySettingService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
@Api(tags = "工时补贴标准配置表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/timesheetSubsidySetting")
@Slf4j
public class TimesheetSubsidySettingController {

private final TimesheetSubsidySettingService timesheetSubsidySettingService;

    /**
     * 工时补贴标准配置表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("工时补贴标准配置表-新增")
    public TwOutputUtil<TimesheetSubsidySettingVO> insert(@RequestBody TimesheetSubsidySettingPayload payload){
         return TwOutputUtil.ok(timesheetSubsidySettingService.insert(payload));
    }

    /**
     * 工时补贴标准配置表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("工时补贴标准配置表-更新")
    public TwOutputUtil<TimesheetSubsidySettingVO> update(@RequestBody TimesheetSubsidySettingPayload payload){
        return TwOutputUtil.ok(timesheetSubsidySettingService.update(payload));
    }

    /**
     * 工时补贴标准配置表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("工时补贴标准配置表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TimesheetSubsidySettingPayload payload){
        return TwOutputUtil.ok(timesheetSubsidySettingService.updateByKeyDynamic(payload));
    }

    /**
     * 工时补贴标准配置表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("工时补贴标准配置表-主键查询")
    public TwOutputUtil<TimesheetSubsidySettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(timesheetSubsidySettingService.queryByKey(key));
    }

    /**
     * 工时补贴标准配置表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("工时补贴标准配置表-分页")
    public TwOutputUtil<PagingVO<TimesheetSubsidySettingVO>> paging(TimesheetSubsidySettingQuery query) {
        return TwOutputUtil.ok(timesheetSubsidySettingService.queryPaging(query));
    }

    /**
     * 工时补贴标准配置表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("工时补贴标准配置表-查询列表")
    public TwOutputUtil<List<TimesheetSubsidySettingVO>> queryList(TimesheetSubsidySettingQuery query) {
        return TwOutputUtil.ok(timesheetSubsidySettingService.queryListDynamic(query));
    }

    /**
     * 工时补贴标准配置表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("工时补贴标准配置表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         timesheetSubsidySettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

