package com.elitesland.tw.tw5.server.prd.my.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QRewardLeaveApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QRewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveApplyRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class RewardLeaveApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final RewardLeaveApplyRepo repo;
    private final QRewardLeaveApplyDO qdo = QRewardLeaveApplyDO.rewardLeaveApplyDO;

    private final QRewardLeaveApplyDetailDO qRewardLeaveApplyDetailDO = QRewardLeaveApplyDetailDO.rewardLeaveApplyDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<RewardLeaveApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(RewardLeaveApplyVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 事由类型
                qdo.reasonType,
                // 事由号
                qdo.reasonId,
                // 事由名称
                qdo.reasonName,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 预计上线日期
                qdo.planOnlineDate,
                // 预算总人天
                qdo.totalDays,
                // 原始规划当量
                qdo.originalPlanEqva,
                // 报告完工百分比
                qdo.reprotCompPercent,
                // 项目风险等级
                qdo.riskLevel,
                // 有效期
                qdo.expirationDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 审批时间
                qdo.approvedTime,
                // 变更当量
                qdo.planEqvaChange,
                // 累计投入当量占比
                qdo.totalEqvaProportion
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<RewardLeaveApplyVO> getJpaQueryWhere(RewardLeaveApplyQuery query) {
        JPAQuery<RewardLeaveApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(RewardLeaveApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(RewardLeaveApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由号 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }
        /** 事由名称 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.eq(query.getReasonName()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 预计上线日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanOnlineDate())) {
            list.add(qdo.planOnlineDate.eq(query.getPlanOnlineDate()));
        }
        /** 预算总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 原始规划当量 精确 */
        if (!ObjectUtils.isEmpty(query.getOriginalPlanEqva())) {
            list.add(qdo.originalPlanEqva.eq(query.getOriginalPlanEqva()));
        }
        /** 报告完工百分比 精确 */
        if (!ObjectUtils.isEmpty(query.getReprotCompPercent())) {
            list.add(qdo.reprotCompPercent.eq(query.getReprotCompPercent()));
        }
        /** 项目风险等级 精确 */
        if (!ObjectUtils.isEmpty(query.getRiskLevel())) {
            list.add(qdo.riskLevel.eq(query.getRiskLevel()));
        }
        /** 有效期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpirationDate())) {
            list.add(qdo.expirationDate.eq(query.getExpirationDate()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 变更当量 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEqvaChange())) {
            list.add(qdo.planEqvaChange.eq(query.getPlanEqvaChange()));
        }
        /** 累计投入当量占比 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalEqvaProportion())) {
            list.add(qdo.totalEqvaProportion.eq(query.getTotalEqvaProportion()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public RewardLeaveApplyVO queryByKey(Long id) {
        JPAQuery<RewardLeaveApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<RewardLeaveApplyVO> queryListDynamic(RewardLeaveApplyQuery query) {
        JPAQuery<RewardLeaveApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<RewardLeaveApplyVO> queryPaging(RewardLeaveApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<RewardLeaveApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<RewardLeaveApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<RewardLeaveApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public RewardLeaveApplyDO save(RewardLeaveApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<RewardLeaveApplyDO> saveAll(List<RewardLeaveApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(RewardLeaveApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由号
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 事由名称
        if (payload.getReasonName() != null) {
            update.set(qdo.reasonName, payload.getReasonName());
        }
        // 预计开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 预计结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 预计上线日期
        if (payload.getPlanOnlineDate() != null) {
            update.set(qdo.planOnlineDate, payload.getPlanOnlineDate());
        }
        // 预算总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 原始规划当量
        if (payload.getOriginalPlanEqva() != null) {
            update.set(qdo.originalPlanEqva, payload.getOriginalPlanEqva());
        }
        // 报告完工百分比
        if (payload.getReprotCompPercent() != null) {
            update.set(qdo.reprotCompPercent, payload.getReprotCompPercent());
        }
        // 项目风险等级
        if (payload.getRiskLevel() != null) {
            update.set(qdo.riskLevel, payload.getRiskLevel());
        }
        // 有效期
        if (payload.getExpirationDate() != null) {
            update.set(qdo.expirationDate, payload.getExpirationDate());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 变更当量
        if (payload.getPlanEqvaChange() != null) {
            update.set(qdo.planEqvaChange, payload.getPlanEqvaChange());
        }
        // 累计投入当量占比
        if (payload.getTotalEqvaProportion() != null) {
            update.set(qdo.totalEqvaProportion, payload.getTotalEqvaProportion());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由号
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 事由名称
            if (nullFields.contains("reasonName")) {
                update.setNull(qdo.reasonName);
            }
            // 预计开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 预计结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
            // 预计上线日期
            if (nullFields.contains("planOnlineDate")) {
                update.setNull(qdo.planOnlineDate);
            }
            // 预算总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 原始规划当量
            if (nullFields.contains("originalPlanEqva")) {
                update.setNull(qdo.originalPlanEqva);
            }
            // 报告完工百分比
            if (nullFields.contains("reprotCompPercent")) {
                update.setNull(qdo.reprotCompPercent);
            }
            // 项目风险等级
            if (nullFields.contains("riskLevel")) {
                update.setNull(qdo.riskLevel);
            }
            // 有效期
            if (nullFields.contains("expirationDate")) {
                update.setNull(qdo.expirationDate);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 变更当量
            if (nullFields.contains("planEqvaChange")) {
                update.setNull(qdo.planEqvaChange);
            }
            // 累计投入当量占比
            if (nullFields.contains("totalEqvaProportion")) {
                update.setNull(qdo.totalEqvaProportion);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public List<RewardLeaveApplyDetailVO> queryAll(RewardLeaveApplyDetailQuery query) {
        return jpaQueryFactory.select(Projections.bean(RewardLeaveApplyDetailVO.class,
                        qdo.reasonId,
                        qdo.reasonType,
                        qdo.reasonName,
                        qdo.expirationDate,
                        qdo.procInstId,
                        qdo.procInstStatus,
                        qRewardLeaveApplyDetailDO.userId,
                        qRewardLeaveApplyDetailDO.applyId,
                        qRewardLeaveApplyDetailDO.appliedDays,
                        qRewardLeaveApplyDetailDO.days,
                        qRewardLeaveApplyDetailDO.workDate,
                        qRewardLeaveApplyDetailDO.workType,
                        qRewardLeaveApplyDetailDO.orgId,
                        qRewardLeaveApplyDetailDO.jobGrade
                )).from(qRewardLeaveApplyDetailDO)
                .leftJoin(qdo).on(qdo.id.eq(qRewardLeaveApplyDetailDO.applyId))
                .where(qRewardLeaveApplyDetailDO.deleteFlag.eq(0))
                .where(qRewardLeaveApplyDetailDO.userId.eq(query.getUserId()))
                .where(qdo.reasonId.eq(query.getReasonId()))
                .where(qdo.reasonType.eq(query.getReasonType()))
                .where(qdo.procInstStatus.eq(ProcInstStatus.APPROVED))
                .fetch();
    }

    public BigDecimal queryAppliedDays(RewardLeaveApplyDetailQuery query) {
        return jpaQueryFactory.select(
                        qRewardLeaveApplyDetailDO.days.sum()
                ).from(qRewardLeaveApplyDetailDO)
                .leftJoin(qdo).on(qdo.id.eq(qRewardLeaveApplyDetailDO.applyId))
                .where(qRewardLeaveApplyDetailDO.deleteFlag.eq(0))
                .where(qRewardLeaveApplyDetailDO.userId.eq(query.getUserId()))
                .where(qdo.reasonId.eq(query.getReasonId()))
                .where(qdo.reasonType.eq(query.getReasonType()))
                .where(qdo.procInstStatus.in(ProcInstStatus.APPROVED, ProcInstStatus.APPROVING))
                .fetchOne();
    }

    public BigDecimal countApplyDaysByDate(RewardLeaveApplyDetailQuery query) {
        return jpaQueryFactory.select(
                        qRewardLeaveApplyDetailDO.days.sum()
                ).from(qRewardLeaveApplyDetailDO)
                .leftJoin(qdo).on(qdo.id.eq(qRewardLeaveApplyDetailDO.applyId))
                .where(qRewardLeaveApplyDetailDO.deleteFlag.eq(0))
                .where(qRewardLeaveApplyDetailDO.userId.eq(query.getUserId()))
                .where(qdo.reasonId.eq(query.getReasonId()))
                .where(qdo.reasonType.eq(query.getReasonType()))
                .where(qdo.procInstStatus.in(ProcInstStatus.APPROVED, ProcInstStatus.APPROVING))
                .where(qRewardLeaveApplyDetailDO.workDate.eq(query.getWorkDate()))
                .fetchOne();
    }

}
