package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRulePayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceRuleVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobttendanceSiteVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRuleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.*;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRuleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class TAttendanceRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TAttendanceRuleRepo repo;
    private final QTAttendanceRuleDO qdo = QTAttendanceRuleDO.tAttendanceRuleDO;
    private final QTwCmsDO qTwCmsDO = QTwCmsDO.twCmsDO;
    private final QTAttendanceNormalDateDO qtAttendanceNormalDateDO = QTAttendanceNormalDateDO.tAttendanceNormalDateDO;
    private final QTAttendanceNormalTimeDO qtAttendanceNormalTimeDO = QTAttendanceNormalTimeDO.tAttendanceNormalTimeDO;

    private final QTAttendanceSiteDO qtAttendanceSiteDO = QTAttendanceSiteDO.tAttendanceSiteDO;

    private final QTAttendanceResDO qtAttendanceResDO = QTAttendanceResDO.tAttendanceResDO;

    private final QTAttendanceNormalDO qtAttendanceNormalDO = QTAttendanceNormalDO.tAttendanceNormalDO;

    private final QTAttendanceOtherDO qtAttendanceOtherDO = QTAttendanceOtherDO.tAttendanceOtherDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceRuleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TAttendanceRuleVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 规则名称
                qdo.ruleName,
                // 规则描述
                qdo.ruleDesc,
                // 汇报对象
                qdo.reportToRes,
                // 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）
                qdo.ruleType,
                // 规则状态，预留
                qdo.ruleStatus,
                // 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）
                qdo.outRangeRuleWay,
                // 员工打卡时是否必须拍照，UDC（YESNO）
                qdo.needPhotoAttendance,
                // 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）
                qdo.attendancePatchApplyLimitCount,
                // 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）
                qdo.ruleEffectiveTime,
                // 强制打卡
                qdo.forceAttendance
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceRuleVO> getJpaQueryWhere(TAttendanceRuleQuery query) {
        JPAQuery<TAttendanceRuleVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TAttendanceRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TAttendanceRuleQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 规则名称 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleName())) {
            list.add(qdo.ruleName.eq(query.getRuleName()));
        }
        /** 规则描述 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleDesc())) {
            list.add(qdo.ruleDesc.eq(query.getRuleDesc()));
        }
        /** 汇报对象 精确 */
        if (!ObjectUtils.isEmpty(query.getReportToRes())) {
            list.add(qdo.reportToRes.eq(query.getReportToRes()));
        }
        /** 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE） 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleType())) {
            list.add(qdo.ruleType.eq(query.getRuleType()));
        }
        /** 规则状态，预留 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleStatus())) {
            list.add(qdo.ruleStatus.eq(query.getRuleStatus()));
        }
        /** 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE） 精确 */
        if (!ObjectUtils.isEmpty(query.getOutRangeRuleWay())) {
            list.add(qdo.outRangeRuleWay.eq(query.getOutRangeRuleWay()));
        }
        /** 员工打卡时是否必须拍照，UDC（YESNO） 精确 */
        if (!ObjectUtils.isEmpty(query.getNeedPhotoAttendance())) {
            list.add(qdo.needPhotoAttendance.eq(query.getNeedPhotoAttendance()));
        }
        /** 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT） 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendancePatchApplyLimitCount())) {
            list.add(qdo.attendancePatchApplyLimitCount.eq(query.getAttendancePatchApplyLimitCount()));
        }
        /** 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ） 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleEffectiveTime())) {
            list.add(qdo.ruleEffectiveTime.eq(query.getRuleEffectiveTime()));
        }
        /** 强制打卡 精确 */
        if (!ObjectUtils.isEmpty(query.getForceAttendance())) {
            list.add(qdo.forceAttendance.eq(query.getForceAttendance()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TAttendanceRuleVO queryByKey(Long id) {
        JPAQuery<TAttendanceRuleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TAttendanceRuleVO> queryListDynamic(TAttendanceRuleQuery query) {
        JPAQuery<TAttendanceRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TAttendanceRuleVO> queryPaging(TAttendanceRuleQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TAttendanceRuleVO> jpaQuery = getJpaQueryWhere(query);
        List<TAttendanceRuleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TAttendanceRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TAttendanceRuleDO save(TAttendanceRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TAttendanceRuleDO> saveAll(List<TAttendanceRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TAttendanceRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 规则名称
        if (payload.getRuleName() != null) {
            update.set(qdo.ruleName, payload.getRuleName());
        }
        // 规则描述
        if (payload.getRuleDesc() != null) {
            update.set(qdo.ruleDesc, payload.getRuleDesc());
        }
        // 汇报对象
        if (payload.getReportToRes() != null) {
            update.set(qdo.reportToRes, payload.getReportToRes());
        }
        // 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）
        if (payload.getRuleType() != null) {
            update.set(qdo.ruleType, payload.getRuleType());
        }
        // 规则状态，预留
        if (payload.getRuleStatus() != null) {
            update.set(qdo.ruleStatus, payload.getRuleStatus());
        }
        // 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）
        if (payload.getOutRangeRuleWay() != null) {
            update.set(qdo.outRangeRuleWay, payload.getOutRangeRuleWay());
        }
        // 员工打卡时是否必须拍照，UDC（YESNO）
        if (payload.getNeedPhotoAttendance() != null) {
            update.set(qdo.needPhotoAttendance, payload.getNeedPhotoAttendance());
        }
        // 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）
        if (payload.getAttendancePatchApplyLimitCount() != null) {
            update.set(qdo.attendancePatchApplyLimitCount, payload.getAttendancePatchApplyLimitCount());
        }
        // 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）
        if (payload.getRuleEffectiveTime() != null) {
            update.set(qdo.ruleEffectiveTime, payload.getRuleEffectiveTime());
        }
        // 强制打卡
        if (payload.getForceAttendance() != null) {
            update.set(qdo.forceAttendance, payload.getForceAttendance());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 规则名称
            if (nullFields.contains("ruleName")) {
                update.setNull(qdo.ruleName);
            }
            // 规则描述
            if (nullFields.contains("ruleDesc")) {
                update.setNull(qdo.ruleDesc);
            }
            // 汇报对象
            if (nullFields.contains("reportToRes")) {
                update.setNull(qdo.reportToRes);
            }
            // 规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）
            if (nullFields.contains("ruleType")) {
                update.setNull(qdo.ruleType);
            }
            // 规则状态，预留
            if (nullFields.contains("ruleStatus")) {
                update.setNull(qdo.ruleStatus);
            }
            // 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）
            if (nullFields.contains("outRangeRuleWay")) {
                update.setNull(qdo.outRangeRuleWay);
            }
            // 员工打卡时是否必须拍照，UDC（YESNO）
            if (nullFields.contains("needPhotoAttendance")) {
                update.setNull(qdo.needPhotoAttendance);
            }
            // 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）
            if (nullFields.contains("attendancePatchApplyLimitCount")) {
                update.setNull(qdo.attendancePatchApplyLimitCount);
            }
            // 规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）
            if (nullFields.contains("ruleEffectiveTime")) {
                update.setNull(qdo.ruleEffectiveTime);
            }
            // 强制打卡
            if (nullFields.contains("forceAttendance")) {
                update.setNull(qdo.forceAttendance);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public String cmsContents() {
        return jpaQueryFactory.select(qTwCmsDO.contents)
                .from(qTwCmsDO)
                .where(qTwCmsDO.cmsNo.eq("ATTENDANCT"))
                .where(qTwCmsDO.enableFlag.eq(1L))
                .where(qTwCmsDO.deleteFlag.eq(0))
                .fetchOne();
    }

    public String cmsOtherContents() {
        return jpaQueryFactory.select(qTwCmsDO.contents)
                .from(qTwCmsDO)
                .where(qTwCmsDO.cmsNo.eq("ATTENDANCT_OTHER"))
                .where(qTwCmsDO.enableFlag.eq(1L))
                .where(qTwCmsDO.deleteFlag.eq(0))
                .fetchOne();
    }


    public List<MobAttendanceRuleVO> getAttendanceRuleByResId(List<Long> attendanceIds) {

        return jpaQueryFactory.select(Projections.bean(MobAttendanceRuleVO.class,
                        qdo.id.as("attendanceRuleId"),
                        qdo.ruleName,
                        qdo.ruleDesc,
                        qdo.reportToRes,
                        qdo.ruleType,
                        qdo.outRangeRuleWay,
                        qdo.needPhotoAttendance,
                        qdo.attendancePatchApplyLimitCount,
                        qdo.forceAttendance,
                        qtAttendanceNormalDateDO.attendanceDateMon,
                        qtAttendanceNormalDateDO.attendanceDateTue,
                        qtAttendanceNormalDateDO.attendanceDateWed,
                        qtAttendanceNormalDateDO.attendanceDateThu,
                        qtAttendanceNormalDateDO.attendanceDateFri,
                        qtAttendanceNormalDateDO.attendanceDateSat,
                        qtAttendanceNormalDateDO.attendanceDateSun,
                        qtAttendanceNormalDateDO.punchLimitStartSecondTime,
                        qtAttendanceNormalDateDO.punchLimitEndSecondTime,
                        qtAttendanceNormalDateDO.allowLateTimeNum,
                        qtAttendanceNormalDateDO.allowLeaveTimeNum
                )).from(qdo)
                .leftJoin(qtAttendanceNormalDateDO).on(qtAttendanceNormalDateDO.attendanceRuleId.eq(qdo.id))
                .where(qdo.id.in(attendanceIds))
                .fetch();

    }

    public List<MobttendanceSiteVO> getAttendanceRuleSite(Long attendanceRuleId) {
        return jpaQueryFactory.select(Projections.bean(MobttendanceSiteVO.class,
                        qtAttendanceSiteDO.id.as("siteId"),
                        qtAttendanceSiteDO.siteDesc,
                        qtAttendanceSiteDO.siteLatitude,
                        qtAttendanceSiteDO.siteLongitude,
                        qtAttendanceSiteDO.siteRadius
                ))
                .from(qtAttendanceSiteDO)
                .where(qtAttendanceSiteDO.attendanceRuleId.eq(attendanceRuleId))
                .fetch();
    }

    public MobAttendanceVO selectAttTime(Long attendanceRuleId) {
        return jpaQueryFactory.select(Projections.bean(MobAttendanceVO.class,
                        qtAttendanceNormalDateDO.punchLimitStartSecondTime,
                        qtAttendanceNormalDateDO.punchLimitEndSecondTime
                )).from(qtAttendanceNormalDateDO)
                .where(qtAttendanceNormalDateDO.attendanceRuleId.eq(attendanceRuleId))
                .fetchOne();
    }

    public List<Long> queryRulesByResId(Long resId) {
        return jpaQueryFactory.select(qtAttendanceResDO.attendanceRuleId)
                .from(qtAttendanceResDO)
                .where(qtAttendanceResDO.resId.eq(resId))
                .fetch();
    }

    public List<Long> queryResByRuleId(Long ruleId) {
        return jpaQueryFactory.select(qtAttendanceResDO.resId)
                .from(qtAttendanceResDO)
                .where(qtAttendanceResDO.attendanceRuleId.eq(ruleId))
                .where(qtAttendanceResDO.resId.isNotNull())
                .fetch();
    }

    public String minAttendanceTimeStart(Long attendanceRuleId) {
        return jpaQueryFactory.select(qtAttendanceNormalTimeDO.attendanceTimeStart.min())
                .from(qtAttendanceNormalTimeDO)
                .where(qtAttendanceNormalTimeDO.attendanceRuleId.eq(attendanceRuleId))
                .fetchOne();
    }

    public String maxAttendanceTimeEnd(Long attendanceRuleId) {

        return jpaQueryFactory.select(qtAttendanceNormalTimeDO.attendanceTimeEnd.max())
                .from(qtAttendanceNormalTimeDO)
                .where(qtAttendanceNormalTimeDO.attendanceRuleId.eq(attendanceRuleId))
                .fetchOne();

    }

    public String minAttendanceTimeStartLatest(Long attendanceRuleId) {
        return jpaQueryFactory.select(qtAttendanceNormalTimeDO.attendanceTimeStart.min())
                .from(qtAttendanceNormalTimeDO)
                .where(qtAttendanceNormalTimeDO.attendanceRuleId.eq(attendanceRuleId))
                .where(qtAttendanceNormalTimeDO.attendanceDateWay.eq("NO"))
                .fetchOne();
    }

    public String maxAttendanceTimeEndEarliest(Long attendanceRuleId) {
        return jpaQueryFactory.select(qtAttendanceNormalTimeDO.attendanceTimeEnd.max())
                .from(qtAttendanceNormalTimeDO)
                .where(qtAttendanceNormalTimeDO.attendanceRuleId.eq(attendanceRuleId))
                .where(qtAttendanceNormalTimeDO.attendanceDateWay.eq("NO"))
                .fetchOne();
    }

    public Long allowLateMin(Long ruleId) {
        return jpaQueryFactory.select(qtAttendanceNormalDateDO.allowLateTimeNum)
                .from(qtAttendanceNormalDateDO)
                .where(qtAttendanceNormalDateDO.attendanceRuleId.eq(ruleId))
                .fetchFirst();
    }

    public Long allowLeaveMin(Long ruleId) {
        return jpaQueryFactory.select(qtAttendanceNormalDateDO.allowLeaveTimeNum)
                .from(qtAttendanceNormalDateDO)
                .where(qtAttendanceNormalDateDO.attendanceRuleId.eq(ruleId))
                .fetchFirst();
    }
}

