package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2023/2/17 - 15:12
 */
@Repository
@RequiredArgsConstructor
public class TimesheetDAO {
    private static final QTimesheetDO qdo = QTimesheetDO.timesheetDO;
    private final QPrdOrgEmployeeDO edo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgEmployeeDO edo1 = new QPrdOrgEmployeeDO("prdOrgEmployeeDO1");
    //    private final QTsApprovalResDO ado = QTsApprovalResDO.tsApprovalResDO;
    //    private static final QTaskInfoDO tdo = QTaskInfoDO.taskInfoDO;
//    private static final QPmsProjectDO pdo = QPmsProjectDO.pmsProjectDO;
    private static final QPrdOrgOrganizationDO odo = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final CacheUtil cacheUtil;

    private final TimesheetRepo timesheetRepo;

    public List<TimesheetVO> queryListByVactionIds(List<Long> vacationApplyDetailIds) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(vacationApplyDetailIds)) {
            jpaQuery.where(qdo.vacationApplyDetailId.in(vacationApplyDetailIds));
        }
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetVO> getJpaQuerySelect() {
        JPAQuery<TimesheetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(TimesheetVO.class,
                qdo.id,
                qdo.tsUserId,
                qdo.tsUserBuId,
                qdo.tsUserBuName,
                qdo.tsStatus,
                qdo.type,
                qdo.apprUserId,
//                qdo.apprUserId.as("oldApprUserId"),//老数据主表审批人
//                ado.approvalResId.as("apprUserId"),//新数据关联表审批人
                qdo.operPlanId,
                qdo.operPlanName,
                qdo.projId,
                qdo.projName,
                qdo.taskId,
                qdo.taskNo,
                qdo.taskName,
                qdo.taskPackageId,
                qdo.taskPackageName,
                qdo.taskPackageNo,
                qdo.taskApplyStatus,
                qdo.actId,
                qdo.actName,
                qdo.actNo,
                qdo.eqva,
                qdo.workType,
                qdo.workDate,
                qdo.workHour,
                qdo.workDesc,
                qdo.weekStartDate,
                qdo.yearWeek,
                qdo.totalManday,
                qdo.totalWorkHour,
                qdo.apprStatus,
                qdo.tsTaskIden,
                qdo.tsActIden,
                qdo.settleStatus,
                qdo.apprResult,
                qdo.workFlag,
                qdo.workDayOff,
                qdo.workRelId,
                qdo.workDayOffStatus,
                qdo.workPlanId,
                qdo.approvalTime,
                qdo.submitTime,
                qdo.lastSubmitTime,
                qdo.autoSaveFlag,
                qdo.autoUpdateFlag,
                qdo.returnFlag,
                qdo.reasonId,
                qdo.reasonName,
                qdo.reasonType,
                qdo.stageId,
                qdo.stageNo,
                qdo.stageName,
                qdo.stageName,
                qdo.subsidyAmt,
                qdo.ext4,
                qdo.ext5,
                qdo.ext3,
                qdo.ext2,
                qdo.ext1,
                qdo.procId,
                qdo.ut,
                qdo.vacationApplyDetailId,
//                        qdo.ext1,
//                        qdo.ext2,
//                        qdo.ext3,
//                        qdo.ext4,
//                        qdo.ext5,
//                        edo.extString5.as("baseCityId"),
                //   pdo.productNo,
                // odo.id.as("expenseBuId"),
                qdo.bangwo8No,
                qdo.bangwo8WorkHour,
                qdo.location
        )).from(qdo);
//        .leftJoin(ado).on(ado.timesheetId.longValue().eq(qdo.id.longValue()).and(ado.approvalStatus.in(TimesheetStatus.APPROVING.getCode(),TimesheetStatus.APPROVED.getCode())));//保证不会查出超过一条的记录
//                .leftJoin(edo).on(qdo.tsUserId.longValue().eq(edo.userId.longValue()));
//                .leftJoin(pdo).on(qdo.projId.longValue().eq(pdo.id.longValue()).and(pdo.deleteFlag.eq(0)))
//                .leftJoin(tdo).on(qdo.taskId.longValue().eq(tdo.id.longValue()).and(tdo.deleteFlag.eq(0)));
        // .leftJoin(odo).on(odo.orgIdV4.longValue().eq(tdo.expenseBuId.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetVO> getJpaQueryWhere(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getActName())) {
            jpaQuery.where(qdo.actName.like(SqlUtil.toSqlLikeString(query.getActName())));
        }
        if (!ObjectUtils.isEmpty(query.getTaskName())) {
            String actIden = cacheUtil.getSystemSelectionValueByName("prd:timesheet:actType", query.getTaskName());
            if (StringUtils.hasText(actIden) && !query.getTaskName().equals(actIden)) {
                jpaQuery.where(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())).or(qdo.tsActIden.eq(actIden)));
            } else {
                jpaQuery.where(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
            }

        }
        if (!ObjectUtils.isEmpty(query.getTaskPackageName())) {
            if (query.getTaskPackageName().equals("无任务")) {
                jpaQuery.where(qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())).or((qdo.projId.isNull().or(qdo.projId.eq(0L))).and(qdo.taskPackageId.isNull().or(qdo.taskPackageId.eq(0L)))));
            } else {
                jpaQuery.where(qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())));
            }
        }
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            jpaQuery.where(qdo.projId.eq(query.getProjId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserId())) {
            jpaQuery.where(qdo.tsUserId.eq(query.getTsUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserBuId())) {
            jpaQuery.where(qdo.tsUserBuId.eq(query.getTsUserBuId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsStatus())) {
            jpaQuery.where(qdo.tsStatus.eq(query.getTsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getTsStatusList())) {
            jpaQuery.where(qdo.tsStatus.in(query.getTsStatusList()));
        }
        // 事由类型
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            jpaQuery.where(qdo.reasonType.eq(query.getReasonType()));
        }
        // 事由类型
        if (!ObjectUtils.isEmpty(query.getReasonTypes())) {
            jpaQuery.where(qdo.reasonType.in(query.getReasonTypes()));
        }
        // 事由id
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            jpaQuery.where(qdo.reasonId.eq(query.getReasonId()));
        }
        // 事由id
        if (!ObjectUtils.isEmpty(query.getReasonIdList())) {
            jpaQuery.where(qdo.reasonId.in(query.getReasonIdList()));
        }
        // 转移到审批表中
        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
            jpaQuery.where(qdo.apprUserId.eq(query.getApprUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserIdList())) {
            jpaQuery.where(qdo.tsUserId.in(query.getTsUserIdList()));
        }
//        if (!ObjectUtils.isEmpty(query.getBaseCityId())) {
//            jpaQuery.where(edo.extString5.eq(query.getBaseCityId().toString()));
//        }
//        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
//            jpaQuery.where(qdo.apprUserId.eq(query.getApprUserId()).or(ado.approvalResId.eq(query.getApprUserId())));
//            BooleanExpression orExpression1 = (ado.id.isNull().and(qdo.apprUserId.eq(query.getApprUserId())));
//            BooleanExpression orExpression2 = (ado.id.isNotNull().and(ado.approvalResId.eq(query.getApprUserId())));
//            BooleanExpression orExpression = orExpression1.or(orExpression2);
//            jpaQuery.where(orExpression);
//        }
//        if (!ObjectUtils.isEmpty(query.getTsUserIdList())) {
//            jpaQuery.where(qdo.tsUserId.in(query.getTsUserIdList()));
//        }
        if (!ObjectUtils.isEmpty(query.getWorkDateBetween())) {
            jpaQuery.where(qdo.workDate.between(query.getWorkDateBetween().get(0), query.getWorkDateBetween().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getWorkDate())) {
            jpaQuery.where(qdo.workDate.between(query.getWorkDate().get(0), query.getWorkDate().get(1)));
        }
        if (!ObjectUtils.isEmpty(query.getNonHolidayFlag()) && query.getNonHolidayFlag() == 1) {
            jpaQuery.where((qdo.tsTaskIden.isNull().or(qdo.tsTaskIden.ne("VACATION"))).and(qdo.tsActIden.isNull().or(qdo.tsActIden.ne("LEGALHOLIDAY"))));
        }
        //去除无任务
        if (!ObjectUtils.isEmpty(query.getNoTaskFlag())) {
            if (query.getNoTaskFlag() == 0) {
                //查无任务
                // jpaQuery.where(qdo.projId.isNull().or(qdo.projId.eq(0L)));
                jpaQuery.where(qdo.taskPackageId.isNull().or(qdo.taskPackageId.eq(0L)));
            }
            if (query.getNoTaskFlag() == 1) {
                //去除无任务
//                jpaQuery.where(qdo.projId.gt(0L).and(qdo.taskPackageId.gt(0L)));
                jpaQuery.where(qdo.taskPackageId.gt(0L));
            }
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("workDate"));
//        orderse.add(OrderItem.desc("createTime"));

        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TimesheetVO> queryPaging(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<TimesheetVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<TimesheetVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public List<TimesheetVO> queryList(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }


    public List<LocalDate> writedDate(Long userId, LocalDate startDate, LocalDate endDate) {
        List<Date> dates = timesheetRepo.queryWritedTsDateList(startDate, endDate, userId);
        List<LocalDate> collect = dates.stream().map(date -> date.toLocalDate()).collect(Collectors.toList());
        return collect;
//        return jpaQueryFactory.select(qdo.workDate)
//                .from(qdo)
//                .where(qdo.workDate.between(startDate, endDate))
//                .where(qdo.tsUserId.eq(userId))
//                .where(qdo.tsStatus.in("APPROVED","APPROVING"))
//                .groupBy(qdo.workDate, qdo.tsUserId)
//                .fetch();
    }

    public List<LocalDate> backDate(Long userId, LocalDate startDate, LocalDate endDate) {
        return jpaQueryFactory.select(qdo.workDate)
                .from(qdo)
                .where(qdo.workDate.between(startDate, endDate))
                .where(qdo.tsUserId.eq(userId))
                .where(qdo.tsStatus.eq("REJECTED"))
                .groupBy(qdo.workDate, qdo.tsUserId)
                .fetch();
    }

    public List<TimesheetApproveQuery> approvingDate(LocalDate startDate, LocalDate endDate) {
        return jpaQueryFactory.select(Projections.bean(
                        TimesheetApproveQuery.class,
                        qdo.tsUserId,
                        qdo.workDate,
                        qdo.apprUserId,
                        edo.employeeName,
                        edo1.employeeName.as("apprName"),
                        edo1.wecomId.as("apprWxId")
                ))
                .from(qdo)
                .leftJoin(edo).on(edo.userId.eq(qdo.tsUserId))
                .leftJoin(edo1).on(edo1.userId.eq(qdo.apprUserId))
                .where(qdo.workDate.between(startDate, endDate))
                .where(qdo.tsStatus.eq("APPROVING"))
                .where(qdo.tsTaskIden.notIn("VACATION").or(qdo.tsTaskIden.isNull()))
                .where(qdo.apprUserId.isNotNull())
                .where(qdo.deleteFlag.eq(0))
                .where(edo1.employeeNo.notIn("80100001", "80100098"))
                .groupBy(qdo.tsUserId, qdo.apprUserId)
                .fetch();
    }

    public List<Long> getWeekNotWorkDate(LocalDate firstDayOfMonth, LocalDate lastDayOfMonth) {

        List<Long> res = jpaQueryFactory.select(qdo.id)
                .from(qdo)
                .where(qdo.workHour.eq(new BigDecimal(8)))
                // 法定假期生成的
                .where(qdo.workFlag.eq("NO"))
                .where(qdo.tsTaskIden.eq("VACATION"))
                .where(qdo.tsActIden.eq("LEGALHOLIDAY"))
                // 自动审批
                .where(qdo.autoSaveFlag.eq(1))
                .where(qdo.tsStatus.eq(TimesheetStatus.APPROVING.getCode()))
                .where(qdo.workDate.between(firstDayOfMonth, lastDayOfMonth))
                .fetch();

        return res;
    }

    public Long updateStateByTask(List<Long> ids) {

        long res = jpaQueryFactory.update(qdo)
                .set(qdo.tsStatus, TimesheetStatus.APPROVED.getCode())
                .set(qdo.apprResult, "审批通过")
                .set(qdo.approvalTime, LocalDateTime.now())
                .where(qdo.id.in(ids))
                .execute();
        return res;

    }

    public Long deleteByVacationApplyId(List<Long> applyDetailIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.vacationApplyDetailId.in(applyDetailIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public Long updateStatusByVacationApplyId(List<Long> applyDetailIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.tsStatus, "APPROVED")
                .where(qdo.vacationApplyDetailId.in(applyDetailIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主表id进行删除
     *
     * @param ids 主表id
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(ids));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}
