package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 员工-个人配置
 *
 * @author wangly
 * @date 2024-03-27
 */
@Entity
@Table(name = "prd_org_employee_config", indexes = {
        @Index(name = "user_id_index", columnList = "user_id")
})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee_config", comment = "员工-个人配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeConfigDO extends BaseModel implements Serializable  {
    /** 员工id */
    @Comment("员工id")
    @Column(name = "user_id")
    private Long userId;
    /** 类型 */
    @Comment("类型")
    @Column()
    private String configType;
    /** 内容 */
    @Comment("内容")
    @Column(name = "content_json", columnDefinition = "text comment '内容'")
    private String contentJson;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字段4 */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /** 扩展字段5 */
    @Comment("扩展字段5")
    @Column()
    private String ext5;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(PrdOrgEmployeeConfigDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
