package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

@Entity
@Table(name = "reward_leave_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "reward_leave_config", comment = "奖励假配置表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class RewardLeaveConfigDO extends BaseModel {

    @Comment("年度")
    @Column()
    private Long leaveYear;

    @Comment("交付BU_ID")
    @Column()
    private Long deliBuId;

    @Comment("项目ID")
    @Column()
    private Long projectId;

    @Comment("职级范围")
    @Column()
    private String jobGradeList;

    @Comment("管理职级范围")
    @Column()
    private String jobGrade2List;

    @Comment("上限天数")
    @Column()
    private BigDecimal leaveDaysUp;

    public void copy(RewardLeaveConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
