package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Entity
@Table(name = "t_busi_card_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_busi_card_apply", comment = "名片申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TBusiCardApplyDO extends BaseModel implements Serializable  {
    /** 英文名 */
    @Comment("英文名")
    @Column()
    private String eName;
    /** BaseBU */
    @Comment("BaseBU")
    @Column()
    private Long basebuId;
    /** 所属公司 */
    @Comment("所属公司")
    @Column()
    private Long ouId;
    /** 手机号 */
    @Comment("手机号")
    @Column()
    private String mobile;
    /** 邮箱 */
    @Comment("邮箱")
    @Column()
    private String email;
    /** 中文抬头 */
    @Comment("中文抬头")
    @Column()
    private String cTitle;
    /** 英文抬头 */
    @Comment("英文抬头")
    @Column()
    private String eTitle;
    /** 邮件标志 */
    @Comment("邮件标志")
    @Column()
    private String mailFlag;
    /** 名片邮寄地址 */
    @Comment("名片邮寄地址")
    @Column()
    private String mailAddr;
    /** 申请结果 */
    @Comment("申请结果")
    @Column()
    private String applyResult;
    /** 取消原因 */
    @Comment("取消原因")
    @Column()
    private String cancelReason;
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(TBusiCardApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
