package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRecordPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRecordQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRecordService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRecordVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRecordConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRecordDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRecordDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRecordRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class TAttendanceRecordServiceImpl extends BaseServiceImpl implements TAttendanceRecordService {

    private final TAttendanceRecordRepo tAttendanceRecordRepo;
    private final TAttendanceRecordDAO tAttendanceRecordDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;

    @Value("${tw4.attendance.record}")
    private String attendanceRecordTo5Url;

    @Override
    public PagingVO<TAttendanceRecordVO> queryPaging(TAttendanceRecordQuery query) {
        return tAttendanceRecordDAO.queryPaging(query);
    }

    @Override
    public List<TAttendanceRecordVO> queryListDynamic(TAttendanceRecordQuery query) {
        return tAttendanceRecordDAO.queryListDynamic(query);
    }

    @Override
    public TAttendanceRecordVO queryByKey(Long key) {
        TAttendanceRecordDO entity = tAttendanceRecordRepo.findById(key).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRecordVO vo = TAttendanceRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRecordVO insert(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entityDo = TAttendanceRecordConvert.INSTANCE.toDo(payload);
        return TAttendanceRecordConvert.INSTANCE.toVo(tAttendanceRecordRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceRecordVO update(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entity = tAttendanceRecordRepo.findById(payload.getId()).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceRecordDO entityDo = TAttendanceRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRecordConvert.INSTANCE.toVo(tAttendanceRecordRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entity = tAttendanceRecordRepo.findById(payload.getId()).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tAttendanceRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tAttendanceRecordDAO.deleteSoft(keys);
        }

    }

    @Override
    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return tAttendanceRecordDAO.findResAttendanceLog(resId, attendanceDate);
    }

    @Override
    public String findStartTime(Long id) {
        return tAttendanceRecordDAO.findStartTime(id);
    }

    @Override
    public String findResAttendanceStatus(Long id) {
        return tAttendanceRecordDAO.findResAttendanceStatus(id);
    }

    @Override
    public String findResAttendanceResult(Long id) {
        return tAttendanceRecordDAO.findResAttendanceResult(id);
    }

    @Override
    public void attendanceRecordTo5(String param) {
        String syncType = "attendanceRecordTo5";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("syncVacationApply localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        //同步到5.0
        XxlJobLogger.log("syncVacationApplyDetail syncTime：" + asyncTimeLong);
        String result = httpUtil.sendSyncGet(attendanceRecordTo5Url, reqMap);
        Map<String, Object> data = (Map) JSONObject.parse(result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> attendanceRecordData = (List<Map<String, Object>>) datum;
                //用户请假申请数据构建
                List<TAttendanceRecordDO> tAttendanceRecordDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4AttendanceRecordIds = attendanceRecordData.stream()
                        .map(attendanceRecord -> ((Integer) (attendanceRecord.get("id") == null ? 0 : attendanceRecord.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<TAttendanceRecordDO> oldTAttendanceRecordDOs = tAttendanceRecordRepo.selectByIdV4List(tw4AttendanceRecordIds);
                //idV4相等的进行更新操作
                for (TAttendanceRecordDO attendanceRecordDO : oldTAttendanceRecordDOs) {
                    Long attendanceRecordIdV4 = attendanceRecordDO.getAttendanceRecordIdV4();
                    for (Map applyData : attendanceRecordData) {
                        Long attendanceRecordIdV4FromV4 = ((Integer) ((null == applyData.get("id") ? 0 : applyData.get("id")))).longValue();
                        if (attendanceRecordIdV4.equals(attendanceRecordIdV4FromV4)) {
                            //有则更新表中记录,并跳出内层循环
                            TAttendanceRecordDO attendanceRecordDO1 = this.translateFromV4(applyData, v4AndV5UserIds);
                            attendanceRecordDO1.setId(attendanceRecordDO.getId());
                            tAttendanceRecordDOList.add(attendanceRecordDO1);
                            break;
                        }
                    }
                }
                tAttendanceRecordRepo.saveAll(tAttendanceRecordDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = attendanceRecordData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = ((Integer) (applyData.get("id") == null ? 0 : applyData.get("id"))).longValue();
                    for (TAttendanceRecordDO attendanceRecordDO : oldTAttendanceRecordDOs) {
                        if (attendanceRecordDO.getAttendanceRecordIdV4().equals(applyId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<TAttendanceRecordDO> newTAttendanceRecordDOs = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    TAttendanceRecordDO attendanceRecordDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceRecordDOs.add(attendanceRecordDO1);
                }
                tAttendanceRecordRepo.saveAll(newTAttendanceRecordDOs);
                syncData = "更新了正常打卡" + attendanceRecordData.size() + "条数据";
            } else {
                syncData = "正常打卡数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【正常打卡信息同步，同步日志：{}】", logDO);
    }


    /**
     * 翻译
     *
     * @param attendanceRecordData         v4的数据
     * @param v4AndV5UserIds    v4与v5对应的userId
     * @return
     */
    private TAttendanceRecordDO translateFromV4(Map attendanceRecordData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceRecordDO attendanceRecordDO = BeanUtil.mapToBean(TAttendanceRecordDO.class, attendanceRecordData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceRecordData.get("id")) {
            attendanceRecordDO.setAttendanceRecordIdV4(((Integer) attendanceRecordData.get("id")).longValue());
        }
        if (null != attendanceRecordData.get("attendanceResId")) {
            Long attendanceResId = ((Integer) attendanceRecordData.get("attendanceResId")).longValue();
            attendanceRecordDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceRecordDO;
    }

}

