package com.elitesland.tw.tw5.server.prd.my.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusinessRulesPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusinessRulesQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusinessRulesService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusinessRulesVO;
import com.elitesland.tw.tw5.server.prd.my.convert.TBusinessRulesConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TBusinessRulesDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusinessRulesDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusinessRulesRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class TBusinessRulesServiceImpl extends BaseServiceImpl implements TBusinessRulesService {

    private final TBusinessRulesRepo tBusinessRulesRepo;
    private final TBusinessRulesDAO tBusinessRulesDAO;

    @Override
    public PagingVO<TBusinessRulesVO> queryPaging(TBusinessRulesQuery query) {
        return tBusinessRulesDAO.queryPaging(query);
    }

    @Override
    public List<TBusinessRulesVO> queryListDynamic(TBusinessRulesQuery query) {
        return tBusinessRulesDAO.queryListDynamic(query);
    }

    @Override
    public TBusinessRulesVO queryByKey(Long key) {
        TBusinessRulesDO entity = tBusinessRulesRepo.findById(key).orElseGet(TBusinessRulesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TBusinessRulesVO vo = TBusinessRulesConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusinessRulesVO insert(TBusinessRulesPayload payload) {
        TBusinessRulesDO entityDo = TBusinessRulesConvert.INSTANCE.toDo(payload);
        return TBusinessRulesConvert.INSTANCE.toVo(tBusinessRulesRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusinessRulesVO update(TBusinessRulesPayload payload) {
        TBusinessRulesDO entity = tBusinessRulesRepo.findById(payload.getId()).orElseGet(TBusinessRulesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TBusinessRulesDO entityDo = TBusinessRulesConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TBusinessRulesConvert.INSTANCE.toVo(tBusinessRulesRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TBusinessRulesPayload payload) {
        TBusinessRulesDO entity = tBusinessRulesRepo.findById(payload.getId()).orElseGet(TBusinessRulesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tBusinessRulesDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tBusinessRulesDAO.deleteSoft(keys);
        }
    }

}
