package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略模型指标
 *
 * @author wangly
 * @date 2023-06-19
 */
@Entity
@Table(name = "business_model_index", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_model_index", comment = "分级策略模型指标")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessModelIndexDO extends BaseModel implements Serializable  {
    /** 模型id business_strategy_model.id */
    @Comment("模型id business_strategy_model.id")
    @Column()
    private Long modelId;
    /** 指标名称 */
    @Comment("指标名称")
    @Column()
    private String modelIndexName;
    /** 数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD] */
    @Comment("数据库字段 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE_FIELD]")
    @Column()
    private String sourceField;
    /** 权重 */
    @Comment("权重")
    @Column()
    private BigDecimal weight;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessModelIndexDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
