package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRangeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRangeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyRangeSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRangeSettingVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyRangeSettingConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyRangeSettingDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyRangeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRangeSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 分级策略范围配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyRangeSettingServiceImpl extends BaseServiceImpl implements BusinessStrategyRangeSettingService {

    private final BusinessStrategyRangeSettingRepo businessStrategyRangeSettingRepo;
    private final BusinessStrategyRangeSettingDAO businessStrategyRangeSettingDAO;

    @Override
    public PagingVO<BusinessStrategyRangeSettingVO> queryPaging(BusinessStrategyRangeSettingQuery query){
        return businessStrategyRangeSettingDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyRangeSettingVO> queryListDynamic(BusinessStrategyRangeSettingQuery query){
        return businessStrategyRangeSettingDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyRangeSettingVO queryByKey(Long key) {
        BusinessStrategyRangeSettingDO entity = businessStrategyRangeSettingRepo.findById(key).orElseGet(BusinessStrategyRangeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyRangeSettingVO vo = BusinessStrategyRangeSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyRangeSettingVO insert(BusinessStrategyRangeSettingPayload payload) {
        BusinessStrategyRangeSettingDO entityDo = BusinessStrategyRangeSettingConvert.INSTANCE.toDo(payload);
        return BusinessStrategyRangeSettingConvert.INSTANCE.toVo(businessStrategyRangeSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyRangeSettingVO update(BusinessStrategyRangeSettingPayload payload) {
        BusinessStrategyRangeSettingDO entity = businessStrategyRangeSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyRangeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyRangeSettingDO entityDo = BusinessStrategyRangeSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyRangeSettingConvert.INSTANCE.toVo(businessStrategyRangeSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyRangeSettingPayload payload) {
        BusinessStrategyRangeSettingDO entity = businessStrategyRangeSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyRangeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyRangeSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyRangeSettingDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveAll(List<BusinessStrategyRangeSettingPayload> payloadList,Long strategyId) {
        List<BusinessStrategyRangeSettingDO> BusinessStrategyRangeSettingDOList = payloadList.stream().map(payLoad -> {
            BusinessStrategyRangeSettingDO businessStrategyRangeSettingDO = new BusinessStrategyRangeSettingDO();
            BeanUtil.copyProperties(payLoad,businessStrategyRangeSettingDO, CopyOptions.create().setIgnoreNullValue(true));
            businessStrategyRangeSettingDO.setStrategyId(strategyId);
            return businessStrategyRangeSettingDO;
        }).collect(Collectors.toList());
        businessStrategyRangeSettingRepo.saveAll(BusinessStrategyRangeSettingDOList);
    }

    @Override
    public List<BusinessStrategyRangeSettingVO> queryListByStrategyId(Long strategyId) {
        List<BusinessStrategyRangeSettingDO> businessStrategyRangeSettingDOList = businessStrategyRangeSettingRepo.findByStrategyIdAndDeleteFlag(strategyId, 0);
        List<BusinessStrategyRangeSettingVO> businessStrategyRangeSettingVOList = BusinessStrategyRangeSettingConvert.INSTANCE.toVoList(businessStrategyRangeSettingDOList);
        return businessStrategyRangeSettingVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByStrategyId(Long strategyId) {
        businessStrategyRangeSettingDAO.deleteSoftByStrategyId(strategyId);
    }
}
