package com.elitesland.tw.tw5.server.prd.pay.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.TDocHistQuery;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.pay.vo.TDocHistVO;
import com.elitesland.tw.tw5.server.prd.pay.convert.TDocHistConvert;
import com.elitesland.tw.tw5.server.prd.pay.dao.TDocHistDAO;
import com.elitesland.tw.tw5.server.prd.pay.entity.TDocHistDO;
import com.elitesland.tw.tw5.server.prd.pay.repo.TDocHistRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 支付管理-支付履历
 *
 * @author wangly
 * @date 2023-12-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TDocHistServiceImpl extends BaseServiceImpl implements TDocHistService {

    private final TDocHistRepo tDocHistRepo;
    private final TDocHistDAO tDocHistDAO;

    @Override
    public PagingVO<TDocHistVO> queryPaging(TDocHistQuery query) {
        return tDocHistDAO.queryPaging(query);
    }

    @Override
    public List<TDocHistVO> queryListDynamic(TDocHistQuery query) {
        return tDocHistDAO.queryListDynamic(query);
    }

    @Override
    public TDocHistVO queryByKey(Long key) {
        TDocHistDO entity = tDocHistRepo.findById(key).orElseGet(TDocHistDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TDocHistVO vo = TDocHistConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TDocHistVO insert(TDocHistPayload payload) {
        TDocHistDO entityDo = TDocHistConvert.INSTANCE.toDo(payload);
        return TDocHistConvert.INSTANCE.toVo(tDocHistRepo.save(entityDo));
    }

    @Override
    public void batchInsert(List<TDocHistPayload> payloads) {
        List<TDocHistDO> dos = TDocHistConvert.INSTANCE.payloads2Dos(payloads);
        tDocHistDAO.saveAll(dos);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TDocHistVO update(TDocHistPayload payload) {
        TDocHistDO entity = tDocHistRepo.findById(payload.getId()).orElseGet(TDocHistDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TDocHistDO entityDo = TDocHistConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TDocHistConvert.INSTANCE.toVo(tDocHistRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TDocHistPayload payload) {
        TDocHistDO entity = tDocHistRepo.findById(payload.getId()).orElseGet(TDocHistDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tDocHistDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tDocHistDAO.deleteSoft(keys);
        }
    }

}
