package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanVersionDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanVersionDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanVersionRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 人员规划版本
 *
 * @author wangly
 * @date 2024-04-07
 */
@Repository
@RequiredArgsConstructor
public class PersonPlanVersionDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PersonPlanVersionRepo repo;
    private final QPersonPlanVersionDO qdo = QPersonPlanVersionDO.personPlanVersionDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PersonPlanVersionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PersonPlanVersionVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 类型
                qdo.planType,
                // 资源规划主表id
                qdo.planId,
                // 版本名称
                qdo.versionName,
                // 版本信息
                qdo.changeContent,
                // 变更单据id
                qdo.objId,
                // 版本号
                qdo.versionNo,
                // 变更状态
                qdo.status,
                // 流程状态
                qdo.apprStatus,
                // 流程实例ID
                qdo.procInstId,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PersonPlanVersionVO> getJpaQuerySelectSimple() {
        return jpaQueryFactory.select(Projections.bean(PersonPlanVersionVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 类型
                qdo.planType,
                // 资源规划主表id
                qdo.planId,
                // 版本名称
                qdo.versionName,
                // 变更单据id
                qdo.objId,
                // 版本号
                qdo.versionNo,
                // 变更状态
                qdo.status
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PersonPlanVersionVO> getJpaQueryWhere(PersonPlanVersionQuery query) {
        JPAQuery<PersonPlanVersionVO> jpaQuery = getJpaQuerySelectSimple();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PersonPlanVersionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PersonPlanVersionQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 类型 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanType())) {
            list.add(qdo.planType.eq(query.getPlanType()));
        }
        /** 资源规划主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanId())) {
            list.add(qdo.planId.eq(query.getPlanId()));
        }
        /** 版本名称 精确 */
        if (!ObjectUtils.isEmpty(query.getVersionName())) {
            list.add(qdo.versionName.like(SqlUtil.toSqlLikeString(query.getVersionName())));
        }
        /** 版本信息 精确 */
        if (!ObjectUtils.isEmpty(query.getChangeContent())) {
            list.add(qdo.changeContent.eq(query.getChangeContent()));
        }
        /** 变更单据id 精确 */
        if (!ObjectUtils.isEmpty(query.getObjId())) {
            list.add(qdo.objId.eq(query.getObjId()));
        }
        /** 版本号 精确 */
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            list.add(qdo.versionNo.eq(query.getVersionNo()));
        }
        /** 变更状态 精确 */
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            list.add(qdo.status.eq(query.getStatus()));
        }
        /** 流程状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            list.add(qdo.extString1.eq(query.getExtString1()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            list.add(qdo.extString2.eq(query.getExtString2()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            list.add(qdo.extString3.eq(query.getExtString3()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            list.add(qdo.extString4.eq(query.getExtString4()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            list.add(qdo.extString5.eq(query.getExtString5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PersonPlanVersionVO queryByKey(Long id) {
        JPAQuery<PersonPlanVersionVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PersonPlanVersionVO> queryListDynamic(PersonPlanVersionQuery query) {
        JPAQuery<PersonPlanVersionVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PersonPlanVersionVO> queryPaging(PersonPlanVersionQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PersonPlanVersionVO> jpaQuery = getJpaQueryWhere(query);
        List<PersonPlanVersionVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PersonPlanVersionVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PersonPlanVersionDO save(PersonPlanVersionDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PersonPlanVersionDO> saveAll(List<PersonPlanVersionDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PersonPlanVersionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 类型
        if (payload.getPlanType() != null) {
            update.set(qdo.planType, payload.getPlanType());
        }
        // 资源规划主表id
        if (payload.getPlanId() != null) {
            update.set(qdo.planId, payload.getPlanId());
        }
        // 版本名称
        if (payload.getVersionName() != null) {
            update.set(qdo.versionName, payload.getVersionName());
        }
        // 版本信息
        if (payload.getChangeContent() != null) {
            update.set(qdo.changeContent, payload.getChangeContent());
        }
        // 变更单据id
        if (payload.getObjId() != null) {
            update.set(qdo.objId, payload.getObjId());
        }
        // 版本号
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        // 变更状态
        if (payload.getStatus() != null) {
            update.set(qdo.status, payload.getStatus());
        }
        // 流程状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 类型
            if (nullFields.contains("planType")) {
                update.setNull(qdo.planType);
            }
            // 资源规划主表id
            if (nullFields.contains("planId")) {
                update.setNull(qdo.planId);
            }
            // 版本名称
            if (nullFields.contains("versionName")) {
                update.setNull(qdo.versionName);
            }
            // 版本信息
            if (nullFields.contains("changeContent")) {
                update.setNull(qdo.changeContent);
            }
            // 变更单据id
            if (nullFields.contains("objId")) {
                update.setNull(qdo.objId);
            }
            // 版本号
            if (nullFields.contains("versionNo")) {
                update.setNull(qdo.versionNo);
            }
            // 变更状态
            if (nullFields.contains("status")) {
                update.setNull(qdo.status);
            }
            // 流程状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
            if (nullFields.contains("extString3")) {
                update.setNull(qdo.extString3);
            }
            if (nullFields.contains("extString4")) {
                update.setNull(qdo.extString4);
            }
            if (nullFields.contains("extString5")) {
                update.setNull(qdo.extString5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

