package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Api(tags = "项目成员")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectMembers")
@Slf4j
public class PmsProjectMembersController {

    private final PmsProjectMembersService pmsProjectMembersService;


    /**
     * 项目成员-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertOrUpdate")
    @ApiOperation("项目成员-新增或修改")
    public TwOutputUtil<PmsProjectMembersVO> insertOrUpdate(@RequestBody PmsProjectMembersPayload payload){
        return TwOutputUtil.ok(pmsProjectMembersService.insertOrUpdate(payload));
    }


    /**
     * 通过项目id查询项目成员 树型
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryTreeByProjId")
    @UdcNameClass
    @ApiOperation("通过项目id查询项目成员 树型")
    public TwOutputUtil<List<PmsProjectMembersVO>> queryTreeByProjId(PmsProjectMembersQuery query) {
        return TwOutputUtil.ok(pmsProjectMembersService.queryTreeByProjId(query));
    }


    /**
     * 项目成员-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目成员-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectMembersService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


//    /**
//     * 项目成员-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("项目成员-主键查询")
//    public TwOutputUtil<PmsProjectMembersVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsProjectMembersService.queryByKey(key));
//    }


    /**
     * 项目成员-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("项目成员-分页")
    public TwOutputUtil<PagingVO<PmsProjectMembersVO>>  paging(PmsProjectMembersQuery query) {
        return TwOutputUtil.ok(pmsProjectMembersService.queryPaging(query));
    }

//    /**
//     * 项目成员-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("项目成员-查询列表")
//    public TwOutputUtil<List<PmsProjectMembersVO>> queryList(PmsProjectMembersQuery query) {
//        return TwOutputUtil.ok(pmsProjectMembersService.queryListDynamic(query));
//    }


//    /**
//     * 项目成员-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("项目成员-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectMembersPayload payload){
//        return TwOutputUtil.ok(pmsProjectMembersService.updateByKeyDynamic(payload));
//    }


}
