package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummarySettingPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummarySettingQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummarySettingService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummarySettingVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectSummarySettingConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectSummarySettingDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSummarySettingDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSummarySettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 会议纪要配置
 *
 * @author zoey
 * @date 2024-05-28
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectSummarySettingServiceImpl extends BaseServiceImpl implements PmsProjectSummarySettingService {

    private final PmsProjectSummarySettingRepo pmsProjectSummarySettingRepo;
    private final PmsProjectSummarySettingDAO pmsProjectSummarySettingDAO;
    private final PmsProjectService pmsProjectService;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService systemRoleService;

    @Override
    public PagingVO<PmsProjectSummarySettingVO> queryPaging(PmsProjectSummarySettingQuery query) {
        PagingVO<PmsProjectSummarySettingVO> pmsProjectSummarySettingVOPagingVO = pmsProjectSummarySettingDAO.queryPaging(query);
        List<PmsProjectSummarySettingVO> records = pmsProjectSummarySettingVOPagingVO.getRecords();
        for (PmsProjectSummarySettingVO record : records) {
            translate(record);
        }
        return pmsProjectSummarySettingVOPagingVO;
    }

    @Override
    public List<PmsProjectSummarySettingVO> queryListDynamic(PmsProjectSummarySettingQuery query) {
        List<PmsProjectSummarySettingVO> records = pmsProjectSummarySettingDAO.queryListDynamic(query);
        for (PmsProjectSummarySettingVO record : records) {
            translate(record);
        }
        return records;
    }

    private void translate(PmsProjectSummarySettingVO record) {
        // 翻译会议纪要人员
        if (StringUtils.hasText(record.getSummaryUsers())) {
            List<String> userNames = new ArrayList<>();
            for (String sourceId : record.getSummaryUsers().split(",")) {
                String userName = cacheUtil.getUserName(Long.parseLong(sourceId));
                userNames.add(userName);
            }
            String userName = String.join(",", userNames);
            record.setSummaryUsersName(userName);
        }
    }

    /**
     * 添加菜单
     *
     * @param users
     */
    private void addMenu(String users) {
        // 翻译会议纪要人员
        if (StringUtils.hasText(users)) {
            List<Long> userList = Arrays.stream(users.split(",")).map(Long::parseLong).collect(Collectors.toList());
            systemRoleService.addUserMenu(userList, "PROJECT_SYMMARY_RES");
        }
    }


    @Override
    public PmsProjectSummarySettingVO queryByKey(Long key) {
        PmsProjectSummarySettingDO entity = pmsProjectSummarySettingRepo.findById(key).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectSummarySettingVO vo = PmsProjectSummarySettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSummarySettingVO insert(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entityDo = PmsProjectSummarySettingConvert.INSTANCE.toDo(payload);
        PmsProjectSummarySettingVO pmsProjectSummarySettingVO = PmsProjectSummarySettingConvert.INSTANCE.toVo(pmsProjectSummarySettingRepo.save(entityDo));
        // 为新人加入会议纪要人员的菜单角色
//        addMenu(payload.getSummaryUsers());
        return pmsProjectSummarySettingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectSummarySettingVO update(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entity = pmsProjectSummarySettingRepo.findById(payload.getId()).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectSummarySettingDO entityDo = PmsProjectSummarySettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PmsProjectSummarySettingVO pmsProjectSummarySettingVO = PmsProjectSummarySettingConvert.INSTANCE.toVo(pmsProjectSummarySettingRepo.save(entity));
        // 为新人加入会议纪要人员的菜单角色
//        addMenu(payload.getSummaryUsers());
        return pmsProjectSummarySettingVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectSummarySettingPayload payload) {
        PmsProjectSummarySettingDO entity = pmsProjectSummarySettingRepo.findById(payload.getId()).orElseGet(PmsProjectSummarySettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectSummarySettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectSummarySettingDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PmsProjectVO> queryProjList(Long pmResId, String workType) {
        List<PmsProjectVO> pmsProjectVOS = new ArrayList<>();
        //当前登录人
        Long userId = GlobalUtil.getLoginUserId();
        //查询项目列表
        PmsProjectSummarySettingQuery query = new PmsProjectSummarySettingQuery();
        query.setSummaryUsers(userId.toString());
        List<PmsProjectSummarySettingVO> pmsProjectSummarySettingVOS = queryListDynamic(query);
        if (!CollectionUtils.isEmpty(pmsProjectSummarySettingVOS)) {
            List<Long> deliOrgList = pmsProjectSummarySettingVOS.stream().map(e -> e.getDeliOrgId()).collect(Collectors.toList());
            PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
            pmsProjectQuery.setDeliBuIds(deliOrgList);
            if (!ObjectUtils.isEmpty(pmResId)) {
                pmsProjectQuery.setPmResId(pmResId);
            }
            if (!ObjectUtils.isEmpty(workType)) {
                pmsProjectQuery.setWorkType(workType);
            }
            pmsProjectVOS = pmsProjectService.queryListDynamic(pmsProjectQuery);
        }
        return pmsProjectVOS;
    }

}
