package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsReasonService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsReasonVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 事由管理
 *
 * @author carl
 * @date 2023-10-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsReasonServiceImpl extends BaseServiceImpl implements PmsReasonService {

    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;
    private final CrmLeadsService leadsService;
    private final CrmOpportunityService opportunityService;
    private final PmsProjectDAO pmsProjectDAO;
    @Value("${tw5.sys_default.ou_id:1001}")
    private Long ou_id;

    @Override
    public List<PmsReasonVO> queryReasonInfos(String reasonType) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<PmsReasonVO> list = new ArrayList<>();
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            //查询项目事由
            PmsProjectQuery query = new PmsProjectQuery();
            query.setPmResId(loginUserId);
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            query.setBudgetStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryTaskAuthorizedProjectList(query);
            if (pmsProjectVOS != null) {
                pmsProjectVOS.forEach(vo -> {
                    PmsReasonVO reasonVO = new PmsReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjName());
                    reasonVO.setCode(vo.getProjNo());
                    reasonVO.setExpenseBuId(vo.getDeliBuId());
                    reasonVO.setExpenseBuName(cacheUtil.getOrgName(vo.getDeliBuId()));
                    reasonVO.setExpenseCompanyId(vo.getOuBookId());
                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
                    reasonVO.setCustId(vo.getCustId());
                    reasonVO.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                    list.add(reasonVO);
                });
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            //查询BU事由
            List<PrdOrgOrganizationVO> prdOrgOrganizationVOS = orgService.queryByManageIdOrgs(loginUserId);
            if (prdOrgOrganizationVOS != null) {
                prdOrgOrganizationVOS.forEach(vo -> {
                    PmsReasonVO reasonVO = new PmsReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getOrgName());
                    reasonVO.setCode(vo.getOrgCode());
                    reasonVO.setExpenseBuId(vo.getId());
                    reasonVO.setExpenseBuName(vo.getOrgName());
                    reasonVO.setExpenseCompanyId(ou_id);
                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(ou_id));
                    list.add(reasonVO);
                });
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setPreSaleUserId(loginUserId);
            // query.setProjectStatus("ACTIVE");
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
//            CrmLeadsQuery queryLeads = new CrmLeadsQuery();
//            queryLeads.setSaleUserId(loginUserId);
//            queryLeads.setIds(List.of(loginUserId));
//            queryLeads.setLeadsStatus("follow");
//            queryLeads.setSize(9999);
//            // List<CrmLeadsListVO> crmLeadsListVOS = leadsService.queryList(queryLeads);
//            PagingVO<CrmLeadsListVO> pagingLeadsList = leadsService.paging(queryLeads);
            //查询售前事由
            if (crmOpportunityListVOS != null) {
                crmOpportunityListVOS.forEach(vo -> {
                    PmsReasonVO reasonVO = new PmsReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjectName());
                    reasonVO.setCode(vo.getProjectNo());
                    reasonVO.setExpenseBuId(vo.getPreSaleOrgId());
                    reasonVO.setExpenseBuName(cacheUtil.getOrgName(vo.getPreSaleOrgId()));
                    reasonVO.setExpenseCompanyId(ou_id);
                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(ou_id));
                    reasonVO.setCustId(vo.getCustBookId());
                    reasonVO.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustBookId()));

                    reasonVO.setRemark("商机");
                    list.add(reasonVO);
                });
            }
//            if (pagingLeadsList.getTotal() > 0) {
//                pagingLeadsList.getRecords().forEach(vo -> {
//                    PmsReasonVO reasonVO = new PmsReasonVO();
//                    reasonVO.setId(vo.getId());
//                    reasonVO.setName(vo.getLeadsName());
//                    reasonVO.setCode(vo.getLeadsNo());
//                    reasonVO.setExpenseBuId(vo.getSaleUserBuId());
//                    reasonVO.setExpenseBuName(cacheUtil.getOrgName(vo.getSaleUserBuId()));
//                    reasonVO.setExpenseCompanyId(ou_id);
//                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(ou_id));
//                    reasonVO.setRemark("线索");
//                    list.add(reasonVO);
//                });
//            }
        }

        return list;
    }


}
