package com.elitesland.tw.tw5.server.prd.product.controller;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Api(tags = "产品管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/product")
@Slf4j
public class PrdProductController {

    private final PrdProductService productService;

    /**
     * 产品管理-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("产品管理-新增")
    public TwOutputUtil insert(@RequestBody PrdProductPayload payload){
        return TwOutputUtil.ok(productService.insert(payload));
    }

    /**
     * 产品管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("产品管理-更新")
    public TwOutputUtil update(@RequestBody PrdProductPayload payload){
        return TwOutputUtil.ok(productService.update(payload));
    }

    /**
     * 产品管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("产品管理-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(productService.queryByKey(key));
    }

    /**
     * 产品管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("产品管理-分页")
    public TwOutputUtil paging(PrdProductQuery query) {
        return TwOutputUtil.ok(productService.queryPaging(query));
    }

    /**
     * 产品管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("产品管理-查询列表")
    public TwOutputUtil queryList(PrdProductQuery query) {
        return TwOutputUtil.ok(productService.queryListDynamic(query));
    }

    /**
     * 产品管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("产品管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        productService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
