package com.elitesland.tw.tw5.server.prd.product.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 产品分类
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Entity
@Table(name = "prd_product_class", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_product_class", comment = "产品分类")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdProductClassDO extends BaseModel implements Serializable  {
    /** 分类编号 */
    @Comment("分类编号")
    @Column()
    private String classCode;
    /** 分类名称 */
    @Comment("分类名称")
    @Column()
    private String className;
    /** 分类类型 0小类/1大类 */
    @Comment("分类类型 0小类/1大类")
    @Column()
    private String classType;
    /** 上级ID */
    @Comment("上级ID")
    @Column()
    private Long seniorId;

    @Comment("4.0产品类型id")
    @Column()
    private Long productClassIdV4;

    public void copy(PrdProductClassDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
