package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 结算申请明细
 *
 * @folder 结算申请明细
 * @author wangly
 * @date 2024-08-21
 */
@Api(tags = "结算申请明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/settleApplyDetails")
@Slf4j
public class SettleApplyDetailsController {

private final SettleApplyDetailsService settleApplyDetailsService;

    /**
     * 结算申请明细-新增
     *
     * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("结算申请明细-新增")
    public TwOutputUtil<SettleApplyDetailsVO> insert(@RequestBody SettleApplyDetailsPayload payload){
         return TwOutputUtil.ok(settleApplyDetailsService.insert(payload));
    }

    /**
     * 结算申请明细-更新
     *
         * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("结算申请明细-更新")
    public TwOutputUtil<SettleApplyDetailsVO> update(@RequestBody SettleApplyDetailsPayload payload){
        return TwOutputUtil.ok(settleApplyDetailsService.update(payload));
    }

    /**
     * 结算申请明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 结算申请明细
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("结算申请明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody SettleApplyDetailsPayload payload){
        return TwOutputUtil.ok(settleApplyDetailsService.updateByKeyDynamic(payload));
    }

    /**
     * 结算申请明细-主键查询
     *
     * @folder 结算申请明细
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("结算申请明细-主键查询")
    public TwOutputUtil<SettleApplyDetailsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryByKey(key));
    }

    /**
     * 结算申请明细-分页
     *
         * @folder 结算申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("结算申请明细-分页")
    public TwOutputUtil<PagingVO<SettleApplyDetailsVO>> paging(SettleApplyDetailsQuery query) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryPaging(query));
    }

    /**
     * 结算申请明细-查询列表
     *
     * @folder 结算申请明细
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("结算申请明细-查询列表")
    public TwOutputUtil<List<SettleApplyDetailsVO>> queryList(SettleApplyDetailsQuery query) {
        return TwOutputUtil.ok(settleApplyDetailsService.queryListDynamic(query));
    }

    /**
     * 结算申请明细-删除
     *
         * @folder 结算申请明细
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("结算申请明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         settleApplyDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 结算申请-关联资源查询
     *
     * @folder 关联资源查询
     * @param userId 资源id
     * @param settleStartDate 结算开始日期
     * @param settleEndDate 结算结束日期
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryAssocationResoure")
    @ApiOperation("结算申请明细-关联资源查询")
    public TwOutputUtil<PurchaseAgreementResVO> queryAssocationResoure(Long userId, String settleStartDate, String settleEndDate){
        return TwOutputUtil.ok(settleApplyDetailsService.queryAssocationResoure(userId, TimeUtil.dateFromYmd(settleStartDate), TimeUtil.dateFromYmd(settleEndDate)));
    }
}

