package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitesland.tw.tw5.api.prd.purchase.vo.PcontractPayplanVO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPcontractPayplanDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 旧采购合同付款计划
 *
 * @author likunpeng
 * @date 2024-01-09
 */
@Repository
@RequiredArgsConstructor
public class PcontractPayplanDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPcontractPayplanDO qdo = QPcontractPayplanDO.pcontractPayplanDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PcontractPayplanVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PcontractPayplanVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 采购合同ID
                qdo.pcontractId,
                // 行号
                qdo.lineNo,
                // 付款阶段
                qdo.phaseDesc,
                // 付款号
                qdo.payNo,
                // 付款状态
                qdo.payStatus,
                // 审批状态
                qdo.apprStatus,
                // 当期付款比例
                qdo.payRatio,
                // 当期付款金额
                qdo.payAmt,
                // 预计付款日期
                qdo.planPayDate,
                // 已付款金额
                qdo.actualPayAmt,
                // 实际付款日期
                qdo.actualPayDate,
                // 计划状态
                qdo.planStatus,
                // 付款阶段号
                qdo.phaseNo
        )).from(qdo);
    }

    /**
     * 根据旧采购合同Id查询旧采购付款计划
     * @param contractId 旧采购合同id
     * @return 旧付款计划
     */
    public List<PcontractPayplanVO> findByContractId(Long contractId) {
        JPAQuery<PcontractPayplanVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0).and(qdo.pcontractId.eq(contractId)));
        return jpaQuerySelect.fetch();
    }
}

