package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.*;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.SettleApplyDetailsRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Repository
@RequiredArgsConstructor
public class SettleApplyDetailsDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final SettleApplyDetailsRepo repo;
    private final QSettleApplyDetailsDO qdo = QSettleApplyDetailsDO.settleApplyDetailsDO;
    private final QSettleApplyDO qSettleApplyDO = QSettleApplyDO.settleApplyDO;
    private final QPurchaseAgreementDO qPurchaseAgreementDO = QPurchaseAgreementDO.purchaseAgreementDO;
    private final QPurchaseAgreementResDO qPurchaseAgreementResDO = QPurchaseAgreementResDO.purchaseAgreementResDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<SettleApplyDetailsVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(SettleApplyDetailsVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 主表ID
                qdo.settleApplyId,
                // 采购协议id
                qdo.purchaseAgreementId,
                // 结算资源ID
                qdo.settleResId,
                // 结算开始日期
                qdo.startDate,
                // 结算结束日期
                qdo.endDate,
                // 合作方式
                qdo.coopWay,
                // 结算人天
                qdo.settleDays,
                // 结算单价
                qdo.settlePrice,
                // 结算金额
                qdo.settleAmt,
                // 出差补贴单价
                qdo.businessTripPrice,
                // 出差补贴总额
                qdo.businessTripAmt,
                // 结算总额
                qdo.settlerTotalAmt,
                // 出差天数
                qdo.businessTripDays,
                // 事由类型
                qdo.reasonType,
                // 事由id
                qdo.reasonId,
                // 事由名称
                qdo.reasonName,
                // 事由号
                qdo.reasonNo,
                // 子合同编号
                qdo.saleContractNo,
                // 子合同id
                qdo.saleContractId,
                // 项目归属bu
                qdo.projectBelongBu,
                // 付款时间
                qdo.payTime,
                // 付款金额
                qdo.payAmt,
                // 付款状态
                qdo.payStatus,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字4
                qdo.ext4,
                // 扩展字5
                qdo.ext5,
                //申请人
                qSettleApplyDO.applyUserId,
                // 申请日期
                qSettleApplyDO.applyDate,
                //结算单号
                qSettleApplyDO.settleNo,
                // 审批状态
                qSettleApplyDO.procInstStatus
        )).from(qdo).leftJoin(qSettleApplyDO).on(qdo.settleApplyId.eq(qSettleApplyDO.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<SettleApplyDetailsVO> getJpaQueryWhere(SettleApplyDetailsQuery query) {
        JPAQuery<SettleApplyDetailsVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(SettleApplyDetailsQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(SettleApplyDetailsQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 主表ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleApplyId())) {
            list.add(qdo.settleApplyId.eq(query.getSettleApplyId()));
        }
        /** 采购协议id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseAgreementId())) {
            list.add(qdo.purchaseAgreementId.eq(query.getPurchaseAgreementId()));
        }
        /** 结算资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleResId())) {
            list.add(qdo.settleResId.eq(query.getSettleResId()));
        }
        /** 结算开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.loe(query.getStartDate()));
        }
        /** 结算结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.goe(query.getEndDate()));
        }
        /** 合作方式 精确 */
        if (!ObjectUtils.isEmpty(query.getCoopWay())) {
            list.add(qdo.coopWay.eq(query.getCoopWay()));
        }
        /** 结算人天 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleDays())) {
            list.add(qdo.settleDays.eq(query.getSettleDays()));
        }
        /** 出差天数 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessTripDays())) {
            list.add(qdo.businessTripDays.eq(query.getBusinessTripDays()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }
        /** 事由名称 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.eq(query.getReasonName()));
        }
        /** 事由号 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonNo())) {
            list.add(qdo.reasonNo.eq(query.getReasonNo()));
        }
        /** 子合同编号 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleContractNo())) {
            list.add(qdo.saleContractNo.eq(query.getSaleContractNo()));
        }
        /** 子合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleContractId())) {
            list.add(qdo.saleContractId.eq(query.getSaleContractId()));
        }
        /** 项目归属bu 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectBelongBu())) {
            list.add(qdo.projectBelongBu.eq(query.getProjectBelongBu()));
        }
        /** 付款时间 精确 */
        if (!ObjectUtils.isEmpty(query.getPayTime())) {
            list.add(qdo.payTime.eq(query.getPayTime()));
        }
        /** 付款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getPayAmt())) {
            list.add(qdo.payAmt.eq(query.getPayAmt()));
        }
        /** 付款状态 精确 */
        if (!ObjectUtils.isEmpty(query.getPayStatus())) {
            list.add(qdo.payStatus.eq(query.getPayStatus()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public SettleApplyDetailsVO queryByKey(Long id) {
        JPAQuery<SettleApplyDetailsVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<SettleApplyDetailsVO> queryListDynamic(SettleApplyDetailsQuery query) {
        JPAQuery<SettleApplyDetailsVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<SettleApplyDetailsVO> queryPaging(SettleApplyDetailsQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<SettleApplyDetailsVO> jpaQuery = getJpaQueryWhere(query);
        List<SettleApplyDetailsVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<SettleApplyDetailsVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public SettleApplyDetailsDO save(SettleApplyDetailsDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<SettleApplyDetailsDO> saveAll(List<SettleApplyDetailsDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(SettleApplyDetailsPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 主表ID
        if (payload.getSettleApplyId() != null) {
            update.set(qdo.settleApplyId, payload.getSettleApplyId());
        }
        // 采购协议id
        if (payload.getPurchaseAgreementId() != null) {
            update.set(qdo.purchaseAgreementId, payload.getPurchaseAgreementId());
        }
        // 结算资源ID
        if (payload.getSettleResId() != null) {
            update.set(qdo.settleResId, payload.getSettleResId());
        }
        // 结算开始日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 结算结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 合作方式
        if (payload.getCoopWay() != null) {
            update.set(qdo.coopWay, payload.getCoopWay());
        }
        // 结算人天
        if (payload.getSettleDays() != null) {
            update.set(qdo.settleDays, payload.getSettleDays());
        }
        // 结算单价
        if (payload.getSettlePrice() != null) {
            update.set(qdo.settlePrice, payload.getSettlePrice());
        }
        // 结算金额
        if (payload.getSettleAmt() != null) {
            update.set(qdo.settleAmt, payload.getSettleAmt());
        }
        // 出差补贴单价
        if (payload.getBusinessTripPrice() != null) {
            update.set(qdo.businessTripPrice, payload.getBusinessTripPrice());
        }
        // 出差补贴总额
        if (payload.getBusinessTripAmt() != null) {
            update.set(qdo.businessTripAmt, payload.getBusinessTripAmt());
        }
        // 结算总额
        if (payload.getSettlerTotalAmt() != null) {
            update.set(qdo.settlerTotalAmt, payload.getSettlerTotalAmt());
        }
        // 出差天数
        if (payload.getBusinessTripDays() != null) {
            update.set(qdo.businessTripDays, payload.getBusinessTripDays());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 事由名称
        if (payload.getReasonName() != null) {
            update.set(qdo.reasonName, payload.getReasonName());
        }
        // 事由号
        if (payload.getReasonNo() != null) {
            update.set(qdo.reasonNo, payload.getReasonNo());
        }
        // 子合同编号
        if (payload.getSaleContractNo() != null) {
            update.set(qdo.saleContractNo, payload.getSaleContractNo());
        }
        // 子合同id
        if (payload.getSaleContractId() != null) {
            update.set(qdo.saleContractId, payload.getSaleContractId());
        }
        // 项目归属bu
        if (payload.getProjectBelongBu() != null) {
            update.set(qdo.projectBelongBu, payload.getProjectBelongBu());
        }
        // 付款时间
        if (payload.getPayTime() != null) {
            update.set(qdo.payTime, payload.getPayTime());
        }
        // 付款金额
        if (payload.getPayAmt() != null) {
            update.set(qdo.payAmt, payload.getPayAmt());
        }
        // 付款状态
        if (payload.getPayStatus() != null) {
            update.set(qdo.payStatus, payload.getPayStatus());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 主表ID
            if (nullFields.contains("settleApplyId")) {
                update.setNull(qdo.settleApplyId);
            }
            // 主表ID
            if (nullFields.contains("purchaseAgreementId")) {
                update.setNull(qdo.purchaseAgreementId);
            }
            // 结算资源ID
            if (nullFields.contains("settleResId")) {
                update.setNull(qdo.settleResId);
            }
            // 结算开始日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 结算结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 合作方式
            if (nullFields.contains("coopWay")) {
                update.setNull(qdo.coopWay);
            }
            // 结算人天
            if (nullFields.contains("settleDays")) {
                update.setNull(qdo.settleDays);
            }
            // 结算单价
            if (nullFields.contains("settlePrice")) {
                update.setNull(qdo.settlePrice);
            }
            // 结算金额
            if (nullFields.contains("settleAmt")) {
                update.setNull(qdo.settleAmt);
            }
            // 出差补贴单价
            if (nullFields.contains("businessTripPrice")) {
                update.setNull(qdo.businessTripPrice);
            }
            // 出差补贴总额
            if (nullFields.contains("businessTripAmt")) {
                update.setNull(qdo.businessTripAmt);
            }
            // 结算总额
            if (nullFields.contains("settlerTotalAmt")) {
                update.setNull(qdo.settlerTotalAmt);
            }
            // 出差天数
            if (nullFields.contains("businessTripDays")) {
                update.setNull(qdo.businessTripDays);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 事由名称
            if (nullFields.contains("reasonName")) {
                update.setNull(qdo.reasonName);
            }
            // 事由号
            if (nullFields.contains("reasonNo")) {
                update.setNull(qdo.reasonNo);
            }
            // 子合同编号
            if (nullFields.contains("saleContractNo")) {
                update.setNull(qdo.saleContractNo);
            }
            // 子合同id
            if (nullFields.contains("saleContractId")) {
                update.setNull(qdo.saleContractId);
            }
            // 项目归属bu
            if (nullFields.contains("projectBelongBu")) {
                update.setNull(qdo.projectBelongBu);
            }
            // 付款时间
            if (nullFields.contains("payTime")) {
                update.setNull(qdo.payTime);
            }
            // 付款金额
            if (nullFields.contains("payAmt")) {
                update.setNull(qdo.payAmt);
            }
            // 付款状态
            if (nullFields.contains("payStatus")) {
                update.setNull(qdo.payStatus);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public PurchaseAgreementResVO queryAssocationResoure(Long userId, LocalDate settleStartDate, LocalDate settleEndDate) {
        return jpaQueryFactory.select(Projections.bean(PurchaseAgreementResVO.class,
                // 资源ID
                qPurchaseAgreementResDO.resId,
                // 采购协议单据ID
                qPurchaseAgreementResDO.documentId,
                // 资源开始日期
                qPurchaseAgreementResDO.resStartDate,
                // 资源结束日期
                qPurchaseAgreementResDO.resEndDate,
                // 合作方式
                qPurchaseAgreementResDO.cooperationWay,
                // 结算单价
                qPurchaseAgreementResDO.settlePrice,
                // 出差补助
                qPurchaseAgreementResDO.travelAllowance
        )).from(qPurchaseAgreementResDO).leftJoin(qPurchaseAgreementDO).on(qPurchaseAgreementDO.id.eq(qPurchaseAgreementResDO.documentId))
                .where(qPurchaseAgreementResDO.deleteFlag.eq(0))
                .where(qPurchaseAgreementDO.deleteFlag.eq(0))
                .where(qPurchaseAgreementDO.agreementType.eq(PurchasePaymentEnum.AgreementType.EXTERNAL_SPECIALISTS.getCode()))
                .where(qPurchaseAgreementDO.agreementStatus.eq(PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode()))
                .where(qPurchaseAgreementResDO.resId.eq(userId))
                .where(qPurchaseAgreementResDO.resStartDate.loe(settleStartDate))
                .where(qPurchaseAgreementResDO.resEndDate.goe(settleEndDate))
                .fetchFirst();
    }
}

