package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 付款计划参考
 *
 * @author likunpeng
 * @date 2023-11-22
 */
@Entity
@Table(name = "t_payment_plan_refer", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_payment_plan_refer", comment = "付款计划参考")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PaymentPlanReferDO extends BaseModel implements Serializable  {
    /** 预付款ID（付款申请单表主键） */
    @Comment("预付款ID（付款申请单表主键）")
    @Column()
    private Long paymentApplyId;
    /** 预付款编号 */
    @Comment("预付款编号")
    @Column()
    private String paymentNo;
    /** 付款阶段 */
    @Comment("付款阶段")
    @Column()
    private String paymentStage;
    /** 付款金额（预付款金额） */
    @Comment("付款金额（预付款金额）")
    @Column()
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @Comment("本次付款金额")
    @Column()
    private BigDecimal currentPaymentAmt;
    /** 付款比例 */
    @Comment("付款比例")
    @Column()
    private BigDecimal paymentProportion;
    /** 预计付款日期 */
    @Comment("预计付款日期")
    @Column()
    private LocalDate estimatedPaymentDate;
    /** 采购合同id */
    @Comment("采购合同id")
    @Column()
    private Long contractId;
    /** 采购合同编号 */
    @Comment("采购合同编号")
    @Column()
    private String contractNo;
    /** 付款状态 */
    @Comment("付款状态")
    @Column()
    private String paymentStatus;
    /** 付款时间 */
    @Comment("付款时间")
    @Column()
    private LocalDate paymentDate;

    public void copy(PaymentPlanReferDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
