package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Entity
@Table(name = "settle_apply_details", indexes = {
        @Index(name = "idx_settle_apply_id", columnList = "settle_apply_id"),
        @Index(name = "idx_settle_res_id", columnList = "settle_res_id"),
        @Index(name = "idx_purchase_agreement_id", columnList = "purchase_agreement_id"),
})
@org.hibernate.annotations.Table(appliesTo = "settle_apply_details", comment = "结算申请明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class SettleApplyDetailsDO extends BaseModel implements Serializable  {
    /** 主表ID */
    @Comment("主表ID")
    @Column(name="settle_apply_id")
    private Long settleApplyId;
    /** 采购协议ID */
    @Comment("采购协议ID")
    @Column(name = "purchase_agreement_id")
    private Long purchaseAgreementId;
    /** 结算资源ID */
    @Comment("结算资源ID")
    @Column(name = "settle_res_id")
    private Long settleResId;
    /** 结算开始日期 */
    @Comment("结算开始日期")
    @Column()
    private LocalDate startDate;
    /** 结算结束日期 */
    @Comment("结算结束日期")
    @Column()
    private LocalDate endDate;
    /** 合作方式 */
    @Comment("合作方式")
    @Column()
    private String coopWay;
    /** 结算人天 */
    @Comment("结算人天")
    @Column()
    private BigDecimal settleDays;
    /** 结算单价 */
    @Comment("结算单价")
    @Column()
    private BigDecimal settlePrice;
    /** 结算金额 */
    @Comment("结算金额")
    @Column()
    private BigDecimal settleAmt;
    /** 出差天数 */
    @Comment("出差天数")
    @Column()
    private BigDecimal businessTripDays;
    /** 出差补贴单价 */
    @Comment("出差补贴单价")
    @Column()
    private BigDecimal businessTripPrice;
    /** 出差补贴单价 */
    @Comment("出差补贴总额")
    @Column()
    private BigDecimal businessTripAmt;
    /** 出差补贴单价 */
    @Comment("结算总额")
    @Column()
    private BigDecimal settlerTotalAmt;
    /** 事由类型 */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /** 事由id */
    @Comment("事由id")
    @Column()
    private Long reasonId;
    /** 事由名称 */
    @Comment("事由名称")
    @Column()
    private String reasonName;
    /** 事由号 */
    @Comment("事由号")
    @Column()
    private String reasonNo;
    /** 子合同编号 */
    @Comment("子合同编号")
    @Column()
    private String saleContractNo;
    /** 子合同id */
    @Comment("子合同id")
    @Column()
    private Long saleContractId;
    /** 项目归属bu */
    @Comment("项目归属bu")
    @Column()
    private Long projectBelongBu;
    /** 付款时间 */
    @Comment("付款时间")
    @Column()
    private LocalDateTime payTime;
    /** 付款金额 */
    @Comment("付款金额")
    @Column()
    private BigDecimal payAmt;
    /** 付款状态 */
    @Comment("付款状态")
    @Column()
    private String payStatus;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字4 */
    @Comment("扩展字4")
    @Column()
    private String ext4;
    /** 扩展字5 */
    @Comment("扩展字5")
    @Column()
    private String ext5;

    public void copy(SettleApplyDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
